/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.BackpackContainerComponent;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModComponentTypes;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.ToolSlot;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.CombinedInvWrapper;
import com.tiviacz.travelersbackpack.network.SyncItemStackPacket;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackInventory
implements ITravelersBackpackInventory {
    private InventoryImproved inventory = this.createInventory((class_2371<class_1799>)class_2371.method_10213((int)Tiers.LEATHER.getStorageSlots(), (Object)class_1799.field_8037), true);
    private InventoryImproved craftingInventory = this.createInventory((class_2371<class_1799>)class_2371.method_10213((int)9, (Object)class_1799.field_8037), false);
    private InventoryImproved toolSlots = this.createToolsInventory((class_2371<class_1799>)class_2371.method_10213((int)Tiers.LEATHER.getToolSlots(), (Object)class_1799.field_8037));
    private final InventoryImproved fluidSlots = this.createTemporaryInventory();
    private final FluidTank leftTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final class_1657 player;
    private class_1799 stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;

    public TravelersBackpackInventory(@Nullable class_1799 stack, class_1657 player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        if (stack != null) {
            this.readAllData();
        }
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    public void readTier() {
        this.tier = Tiers.of((Integer)this.stack.method_57825(ModComponentTypes.TIER, (Object)0));
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getToolSlotsInventory() {
        return this.toolSlots;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public InventoryImproved getFluidSlotsInventory() {
        return this.fluidSlots;
    }

    @Override
    public class_1263 getCombinedInventory() {
        return new CombinedInvWrapper(this, this.getInventory(), this.getToolSlotsInventory(), this.getFluidSlotsInventory(), this.getCraftingGridInventory());
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void writeAllData() {
        this.writeItems();
        this.writeTanks();
        this.writeAbility();
        this.writeTime();
        this.slotManager.writeUnsortableSlots(this.stack);
        this.slotManager.writeMemorySlots(this.stack);
        this.settingsManager.writeSettings(this.stack);
    }

    public void readAllData() {
        this.readTier();
        this.readItems();
        this.readTanks();
        this.readAbility();
        this.readTime();
        this.slotManager.readUnsortableSlots(this.stack);
        this.slotManager.readMemorySlots(this.stack);
        this.settingsManager.readSettings(this.stack);
    }

    public void writeItems() {
        this.stack.method_57379(ModComponentTypes.BACKPACK_CONTAINER, (Object)this.itemsToList(this.stack.method_57826(ModComponentTypes.BACKPACK_CONTAINER) ? this.inventory.method_5439() : this.tier.getStorageSlots(), this.inventory));
        this.stack.method_57379(ModComponentTypes.CRAFTING_CONTAINER, (Object)this.itemsToList(9, this.craftingInventory));
        this.stack.method_57379(ModComponentTypes.TOOLS_CONTAINER, (Object)this.itemsToList(this.stack.method_57826(ModComponentTypes.TOOLS_CONTAINER) ? this.toolSlots.method_5439() : this.tier.getToolSlots(), this.toolSlots));
    }

    public void readItems() {
        this.inventory = this.createInventory(((BackpackContainerComponent)this.stack.method_57825(ModComponentTypes.BACKPACK_CONTAINER, (Object)BackpackContainerComponent.fromStacks(this.tier.getStorageSlots(), (List<class_1799>)class_2371.method_10213((int)this.tier.getStorageSlots(), (Object)class_1799.field_8037)))).getStacks(), true);
        this.toolSlots = this.createToolsInventory(((BackpackContainerComponent)this.stack.method_57825(ModComponentTypes.TOOLS_CONTAINER, (Object)BackpackContainerComponent.fromStacks(this.tier.getToolSlots(), (List<class_1799>)class_2371.method_10213((int)this.tier.getToolSlots(), (Object)class_1799.field_8037)))).getStacks());
        this.craftingInventory = this.createInventory(((BackpackContainerComponent)this.stack.method_57825(ModComponentTypes.CRAFTING_CONTAINER, (Object)BackpackContainerComponent.fromStacks(9, (List<class_1799>)class_2371.method_10213((int)9, (Object)class_1799.field_8037)))).getStacks(), false);
    }

    public void writeTanks() {
        this.stack.method_57379(ModComponentTypes.FLUID_TANKS, (Object)new FluidTanks(this.leftTank.getCapacity(), new FluidTanks.Tank((FluidVariant)this.leftTank.getResource(), this.leftTank.getAmount()), new FluidTanks.Tank((FluidVariant)this.rightTank.getResource(), this.rightTank.getAmount())));
    }

    public void readTanks() {
        FluidTanks tanks = (FluidTanks)this.stack.method_57825(ModComponentTypes.FLUID_TANKS, (Object)FluidTanks.createTanks(this.tier.getTankCapacity()));
        this.leftTank.setCapacity(tanks.capacity());
        this.leftTank.variant = tanks.leftTank().fluidVariant();
        this.leftTank.amount = tanks.leftTank().amount();
        this.rightTank.setCapacity(tanks.capacity());
        this.rightTank.variant = tanks.rightTank().fluidVariant();
        this.rightTank.amount = tanks.rightTank().amount();
    }

    public void writeAbility() {
        this.stack.method_57379(ModComponentTypes.ABILITY_SWITCH, (Object)this.ability);
    }

    public void readAbility() {
        this.ability = (Boolean)this.stack.method_57825(ModComponentTypes.ABILITY_SWITCH, (Object)TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled);
    }

    public void writeTime() {
        this.stack.method_57379(ModComponentTypes.LAST_TIME, (Object)this.lastTime);
    }

    public void readTime() {
        this.lastTime = (Integer)this.stack.method_57825(ModComponentTypes.LAST_TIME, (Object)0);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 0, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 2, this.player);
    }

    public BackpackContainerComponent itemsToList(int size, InventoryImproved inventory) {
        return BackpackContainerComponent.fromStacks(size, inventory.getStacks().stream().toList());
    }

    @Override
    public boolean hasColor() {
        return this.stack.method_57826(class_9334.field_49644);
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return ((class_9282)this.stack.method_57824(class_9334.field_49644)).comp_2384();
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.method_57826(ModComponentTypes.SLEEPING_BAG_COLOR);
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return (Integer)this.stack.method_57825(ModComponentTypes.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789());
        }
        return class_1767.field_7964.method_7789();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities ? (TravelersBackpackConfig.isAbilityAllowed(this.getItemStack()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getInventory().method_5439() / 9.0);
    }

    @Override
    public int getYOffset() {
        return 18 * Math.max(0, this.getRows() - 3);
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public class_1937 world() {
        return this.player.method_37908();
    }

    @Override
    public class_2338 getPosition() {
        return this.player.method_24515();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack == null ? class_1799.field_8037 : this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable class_1657 player) {
    }

    @Override
    public void markDataDirty(byte ... dataIds) {
        if (this.world().field_9236 || this.stack == null) {
            return;
        }
        block8: for (byte data : dataIds) {
            switch (data) {
                case 4: {
                    this.writeTanks();
                    continue block8;
                }
                case 7: {
                    this.writeAbility();
                    continue block8;
                }
                case 8: {
                    this.writeTime();
                    continue block8;
                }
                case 9: {
                    this.slotManager.writeUnsortableSlots(this.stack);
                    this.slotManager.writeMemorySlots(this.stack);
                    this.sendMemorySlotsToClient();
                    continue block8;
                }
                case 10: {
                    this.settingsManager.writeSettings(this.stack);
                    continue block8;
                }
                case 11: {
                    this.writeAllData();
                }
            }
        }
        this.sendPackets();
    }

    public void markSlotDirty(int index, class_1799 stack, byte dataId) {
        switch (dataId) {
            case 0: {
                this.stack.method_57367(ModComponentTypes.BACKPACK_CONTAINER, (Object)new BackpackContainerComponent(this.getTier().getStorageSlots()), (Object)new BackpackContainerComponent.Slot(index, stack), BackpackContainerComponent::updateSlot);
                break;
            }
            case 2: {
                this.stack.method_57367(ModComponentTypes.CRAFTING_CONTAINER, (Object)new BackpackContainerComponent(9), (Object)new BackpackContainerComponent.Slot(index, stack), BackpackContainerComponent::updateSlot);
                break;
            }
            case 1: {
                this.stack.method_57367(ModComponentTypes.TOOLS_CONTAINER, (Object)new BackpackContainerComponent(this.tier.getToolSlots()), (Object)new BackpackContainerComponent.Slot(index, stack), BackpackContainerComponent::updateSlot);
            }
        }
        this.sendPackets();
    }

    public void sendMemorySlotsToClient() {
        if (this.player != null && !this.world().field_9236 && this.screenID == 1) {
            this.player.field_7512.method_34252();
        }
    }

    public void sendPackets() {
        class_1657 class_16572;
        if (this.screenID == 2) {
            if (this.slotManager.isSelectorActive((byte)1) || this.slotManager.isSelectorActive((byte)0)) {
                return;
            }
            ComponentUtils.sync(this.player);
        }
        if (this.screenID == 1 && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new SyncItemStackPacket(serverPlayer.method_5628(), this.stack));
        }
    }

    @Override
    public void method_5431() {
    }

    public static void abilityTick(class_1657 player) {
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
            TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
            if (!inv.world().field_9236 && inv.getLastTime() > 0) {
                inv.setLastTime(inv.getLastTime() - 1);
                inv.markDataDirty(8);
            }
            if (inv.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(ComponentUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openHandledScreen(class_1657 player, final class_1799 stack, final byte screenID) {
        if (!player.method_37908().field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.ItemScreenData>(){

                public ModScreenHandlerTypes.ItemScreenData getScreenOpeningData(class_3222 player) {
                    return new ModScreenHandlerTypes.ItemScreenData(screenID, -1);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    if (screenID == 2) {
                        return new TravelersBackpackItemScreenHandler(syncId, inv, ComponentUtils.getBackpackInv(player));
                    }
                    return new TravelersBackpackItemScreenHandler(syncId, inv, new TravelersBackpackInventory(stack, player, screenID));
                }
            });
        }
    }

    public InventoryImproved createInventory(class_2371<class_1799> stacks, final boolean isInventory) {
        return new InventoryImproved(stacks){

            @Override
            public void method_5431() {
            }

            @Override
            public void onContentsChanged(int index) {
                if (isInventory) {
                    TravelersBackpackInventory.this.markSlotDirty(index, this.method_5438(index), (byte)0);
                } else {
                    TravelersBackpackInventory.this.markSlotDirty(index, this.method_5438(index), (byte)2);
                }
            }
        };
    }

    private InventoryImproved createToolsInventory(class_2371<class_1799> stacks) {
        return new InventoryImproved(stacks){

            @Override
            public void method_5431() {
            }

            @Override
            public void onContentsChanged(int index) {
                TravelersBackpackInventory.this.markSlotDirty(index, this.method_5438(index), (byte)1);
            }

            @Override
            public boolean method_5437(int slot, class_1799 stack) {
                return ToolSlot.isValid(stack);
            }
        };
    }

    public FluidTank createFluidTank(long tankCapacity) {
        return new FluidTank(tankCapacity){

            protected void onFinalCommit() {
                TravelersBackpackInventory.this.markDataDirty(4);
            }
        };
    }
}

