/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class BackpackContainerComponent {
    public static final BackpackContainerComponent DEFAULT = new BackpackContainerComponent((class_2371<class_1799>)class_2371.method_10211());
    public static final Codec<BackpackContainerComponent> CODEC = Slot.CODEC.sizeLimitedListOf(256).xmap(BackpackContainerComponent::fromSlots, BackpackContainerComponent::collectSlots);
    public static final class_9139<class_9129, BackpackContainerComponent> PACKET_CODEC = class_1799.field_49268.method_56433(class_9135.method_58000((int)256)).method_56432(BackpackContainerComponent::new, component -> component.stacks);
    private final class_2371<class_1799> stacks;
    private final int hashCode;

    private BackpackContainerComponent(class_2371<class_1799> stacks) {
        if (stacks.size() > 256) {
            throw new IllegalArgumentException("Got " + stacks.size() + " items, but maximum is 256");
        }
        this.stacks = stacks;
        this.hashCode = class_1799.method_57361(stacks);
    }

    public BackpackContainerComponent(int size) {
        this((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037));
    }

    private BackpackContainerComponent(List<class_1799> stacks) {
        this(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.stacks.set(i, (Object)stacks.get(i));
        }
    }

    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public static BackpackContainerComponent upgradeContents(int newSize, class_2371<class_1799> oldContents) {
        ArrayList<class_1799> items = new ArrayList<class_1799>((Collection<class_1799>)oldContents);
        items.addAll((Collection<class_1799>)class_2371.method_10213((int)(newSize - oldContents.size()), (Object)class_1799.field_8037));
        return new BackpackContainerComponent(items);
    }

    private static BackpackContainerComponent fromSlots(List<Slot> slots) {
        OptionalInt optionalInt = slots.stream().mapToInt(Slot::index).max();
        if (optionalInt.isEmpty()) {
            return DEFAULT;
        }
        BackpackContainerComponent containerComponent = new BackpackContainerComponent(optionalInt.getAsInt() + 1);
        for (Slot slot : slots) {
            containerComponent.stacks.set(slot.index(), (Object)slot.item());
        }
        return containerComponent;
    }

    public static BackpackContainerComponent fromStacks(int size, List<class_1799> stacks) {
        BackpackContainerComponent containerComponent = new BackpackContainerComponent(size);
        for (int j = 0; j < size; ++j) {
            containerComponent.stacks.set(j, (Object)stacks.get(j).method_7972());
        }
        return containerComponent;
    }

    private List<Slot> collectSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 itemStack = (class_1799)this.stacks.get(i);
            list.add(new Slot(i, itemStack));
        }
        return list;
    }

    public BackpackContainerComponent updateSlot(Slot slot) {
        ArrayList<class_1799> itemsCopy = new ArrayList<class_1799>((Collection<class_1799>)this.stacks);
        if (slot.index >= 0 && slot.index < itemsCopy.size()) {
            itemsCopy.set(slot.index, slot.item);
        }
        return new BackpackContainerComponent(itemsCopy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BackpackContainerComponent) {
            BackpackContainerComponent containerComponent = (BackpackContainerComponent)o;
            if (class_1799.method_57362(this.stacks, containerComponent.stacks)) {
                boolean var10000 = true;
                return var10000;
            }
        }
        boolean var10000 = false;
        return var10000;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public record Slot(int index, class_1799 item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(Slot::index), (App)class_1799.field_49266.fieldOf("item").forGetter(Slot::item)).apply((Applicative)instance, Slot::new));
    }
}

