/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.trinkets;

import com.tiviacz.travelersbackpack.client.model.BackpackFeatureModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackFeature;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_7923;

public class TravelersBackpackTrinket
implements Trinket {
    public static void init() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> TrinketsApi.registerTrinket((class_1792)item, (Trinket)new TravelersBackpackTrinket()));
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new Renderer()));
    }

    public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        return TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration;
    }

    public boolean canEquipFromUse(class_1799 stack, class_1309 entity) {
        return false;
    }

    public TrinketEnums.DropRule getDropRule(class_1799 stack, SlotReference slot, class_1309 entity) {
        return TrinketEnums.DropRule.DEFAULT;
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                return;
            }
            if (!player.method_37908().field_9236) {
                ComponentUtils.getComponent(player).setContents(stack);
                ComponentUtils.getComponent(player).setWearable(stack);
            }
            ComponentUtils.sync(player);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                return;
            }
            if (!player.method_37908().field_9236) {
                ComponentUtils.getComponent(player).removeWearable();
            }
            ComponentUtils.sync(player);
        }
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler || !ComponentUtils.isWearingBackpack(player)) {
                return;
            }
            class_1799 backpack = ComponentUtils.getWearingBackpack(player);
            if (!class_1799.method_31577((class_1799)backpack, (class_1799)stack)) {
                stack.method_59692(backpack.method_57380());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements TrinketRenderer {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (contextModel instanceof class_591) {
                    class_591 playerEntityModel = (class_591)contextModel;
                    BackpackFeatureModel<?> backpackFeatureModel = BackpackFeatureModel.FEATURE_MODEL;
                    backpackFeatureModel.setBackpackStack(stack);
                    TravelersBackpackFeature.renderBackpackFeature(backpackFeatureModel, (class_572)playerEntityModel, matrices, vertexConsumers, light, (class_1309)player, stack);
                }
            }
        }
    }
}

