/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.accessories;

import com.tiviacz.travelersbackpack.client.model.BackpackFeatureModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackFeature;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_7923;

public class TravelersBackpackAccessory
implements Accessory {
    public static void init() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)new TravelersBackpackAccessory()));
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> AccessoriesRendererRegistry.registerRenderer((class_1792)item, Renderer::new));
    }

    public boolean canEquip(class_1799 stack, SlotReference reference) {
        return TravelersBackpackConfig.getConfig().backpackSettings.accessoriesIntegration;
    }

    public boolean canEquipFromUse(class_1799 stack) {
        return false;
    }

    public void onEquip(class_1799 stack, SlotReference reference) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.accessoriesIntegration) {
            return;
        }
        class_1309 class_13092 = reference.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                return;
            }
            if (!player.method_37908().field_9236) {
                ComponentUtils.getComponent(player).setContents(stack);
                ComponentUtils.getComponent(player).setWearable(stack);
            }
            ComponentUtils.sync(player);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference reference) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.accessoriesIntegration) {
            return;
        }
        class_1309 class_13092 = reference.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                return;
            }
            if (!player.method_37908().field_9236) {
                ComponentUtils.getComponent(player).removeWearable();
            }
            ComponentUtils.sync(player);
        }
    }

    public void tick(class_1799 stack, SlotReference reference) {
        if (!TravelersBackpackConfig.getConfig().backpackSettings.accessoriesIntegration) {
            return;
        }
        class_1309 class_13092 = reference.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler || !ComponentUtils.isWearingBackpack(player)) {
                return;
            }
            if (player.field_7512 instanceof AccessoriesMenuBase) {
                return;
            }
            class_1799 backpack = ComponentUtils.getWearingBackpack(player);
            if (!class_1799.method_31577((class_1799)backpack, (class_1799)stack)) {
                stack.method_59692(backpack.method_57380());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements SimpleAccessoryRenderer {
        public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> entityModel, class_4597 vertexConsumers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            class_1309 class_13092 = reference.entity();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (entityModel instanceof class_591) {
                    class_591 playerEntityModel = (class_591)entityModel;
                    BackpackFeatureModel<?> backpackFeatureModel = BackpackFeatureModel.FEATURE_MODEL;
                    backpackFeatureModel.setBackpackStack(stack);
                    TravelersBackpackFeature.renderBackpackFeature(backpackFeatureModel, (class_572)playerEntityModel, matrices, vertexConsumers, light, (class_1309)player, stack);
                }
            }
        }

        public <M extends class_1309> void align(class_1799 stack, SlotReference reference, class_583<M> model, class_4587 matrices) {
        }
    }
}

