/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.compat.comforts.ComfortsCompat;
import com.tiviacz.travelersbackpack.init.ModComponentTypes;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class ShapedBackpackRecipe
extends class_1869 {
    public ShapedBackpackRecipe(String group, class_7710 category, class_8957 raw, class_1799 result, boolean showNotification) {
        super(group, category, raw, result, showNotification);
    }

    public class_1799 method_17727(class_9694 craftingRecipeInput, class_7225.class_7874 wrapperLookup) {
        class_1799 output = this.method_8110(wrapperLookup).method_7972();
        if (!output.method_7960()) {
            for (int i = 0; i < craftingRecipeInput.method_59983(); ++i) {
                int color;
                class_1799 ingredient = craftingRecipeInput.method_59984(i);
                if (!ingredient.method_7960() && ingredient.method_7909() instanceof TravelersBackpackItem) {
                    output.method_57366(ingredient.method_57380());
                    break;
                }
                if (ingredient.method_7960() || !ingredient.method_31573(ModTags.SLEEPING_BAGS) || (color = ShapedBackpackRecipe.getProperColor(ingredient.method_7909())) == class_1767.field_7964.method_7789()) continue;
                output.method_57379(ModComponentTypes.SLEEPING_BAG_COLOR, (Object)color);
            }
        }
        return output;
    }

    public static int getProperColor(class_1792 item) {
        class_1747 blockItem;
        if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof SleepingBagBlock) {
            return ((SleepingBagBlock)blockItem.method_7711()).method_9487().method_7789();
        }
        if (TravelersBackpack.comfortsLoaded) {
            return ComfortsCompat.getComfortsSleepingBagColor(item);
        }
        return class_1767.field_7964.method_7789();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_SHAPED;
    }

    public static class Serializer
    implements class_1865<ShapedBackpackRecipe> {
        public static final MapCodec<ShapedBackpackRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.method_8112()), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.method_45441()), (App)class_8957.field_47321.forGetter(recipe -> recipe.field_47320), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.field_9053), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.method_49188())).apply((Applicative)instance, ShapedBackpackRecipe::new));
        public static final class_9139<class_9129, ShapedBackpackRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<ShapedBackpackRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ShapedBackpackRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static ShapedBackpackRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)buf.method_10818(class_7710.class);
            class_8957 rawShapedRecipe = (class_8957)class_8957.field_48359.decode((Object)buf);
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            boolean bl = buf.readBoolean();
            return new ShapedBackpackRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, bl);
        }

        private static void write(class_9129 buf, ShapedBackpackRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817((Enum)recipe.method_45441());
            class_8957.field_48359.encode((Object)buf, (Object)recipe.field_47320);
            class_1799.field_48349.encode((Object)buf, (Object)recipe.field_9053);
            buf.method_52964(recipe.method_49188());
        }
    }
}

