/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.components.BackpackContainerComponent;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.components.Settings;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModComponentTypes;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_8060;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9697;

public class BackpackUpgradeRecipe
extends class_8060 {
    final class_1856 template;
    final class_1856 base;
    final class_1856 addition;
    final class_1799 result;

    public BackpackUpgradeRecipe(class_1856 template, class_1856 base, class_1856 addition, class_1799 result) {
        super(template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public class_1799 method_60000(class_9697 smithingRecipeInput, class_7225.class_7874 wrapperLookup) {
        class_1799 result = smithingRecipeInput.method_59984(1).method_56701((class_1935)this.result.method_7909(), this.result.method_7947());
        result.method_57366(this.result.method_57380());
        class_1799 base = smithingRecipeInput.method_59984(1);
        class_1799 addition = smithingRecipeInput.method_59984(2);
        int tier = (Integer)base.method_57825(ModComponentTypes.TIER, (Object)0);
        if (addition.method_31574(Tiers.of(tier).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        if (addition.method_31574(ModItems.CRAFTING_UPGRADE)) {
            if (base.method_57826(ModComponentTypes.SETTINGS)) {
                List oldSettings = (List)base.method_57824(ModComponentTypes.SETTINGS);
                List craftingSettings = (List)oldSettings.get(0);
                if ((Byte)craftingSettings.get(0) == 0) {
                    List<Byte> newCraftingSettings = Arrays.asList((byte)1, (Byte)craftingSettings.get(1), (Byte)craftingSettings.get(2));
                    List<List> newSettings = Arrays.asList(newCraftingSettings, (List)oldSettings.get(1));
                    result.method_57379(ModComponentTypes.SETTINGS, newSettings);
                    return result;
                }
            } else {
                List<Byte> newCraftingSettings = Arrays.asList((byte)1, (byte)0, (byte)1);
                List<List<Byte>> newSettings = Settings.createSettings(newCraftingSettings, Settings.createDefaultToolSettings());
                result.method_57379(ModComponentTypes.SETTINGS, newSettings);
                return result;
            }
        }
        return class_1799.field_8037;
    }

    public void upgradeInventory(class_1799 stack, Tiers.Tier nextTier) {
        stack.method_57379(ModComponentTypes.TIER, (Object)nextTier.getOrdinal());
        class_2371<class_1799> oldContents = ((BackpackContainerComponent)stack.method_57825(ModComponentTypes.BACKPACK_CONTAINER, (Object)BackpackContainerComponent.fromStacks(nextTier.getStorageSlots(), (List<class_1799>)class_2371.method_10213((int)nextTier.getStorageSlots(), (Object)class_1799.field_8037)))).getStacks();
        BackpackContainerComponent newContents = BackpackContainerComponent.upgradeContents(nextTier.getStorageSlots(), oldContents);
        stack.method_57379(ModComponentTypes.BACKPACK_CONTAINER, (Object)newContents);
        class_2371<class_1799> oldTools = ((BackpackContainerComponent)stack.method_57825(ModComponentTypes.TOOLS_CONTAINER, (Object)BackpackContainerComponent.fromStacks(nextTier.getToolSlots(), (List<class_1799>)class_2371.method_10213((int)nextTier.getToolSlots(), (Object)class_1799.field_8037)))).getStacks();
        BackpackContainerComponent newTools = BackpackContainerComponent.upgradeContents(nextTier.getToolSlots(), oldTools);
        stack.method_57379(ModComponentTypes.TOOLS_CONTAINER, (Object)newTools);
        FluidTanks oldTanks = (FluidTanks)stack.method_57825(ModComponentTypes.FLUID_TANKS, (Object)FluidTanks.createTanks(nextTier.getTankCapacity()));
        FluidTanks newTanks = new FluidTanks(nextTier.getTankCapacity(), new FluidTanks.Tank(oldTanks.leftTank().fluidVariant(), oldTanks.leftTank().amount()), new FluidTanks.Tank(oldTanks.rightTank().fluidVariant(), oldTanks.rightTank().amount()));
        stack.method_57379(ModComponentTypes.FLUID_TANKS, (Object)newTanks);
    }

    public boolean method_59999(class_9697 smithingRecipeInput, class_1937 world) {
        class_1799 addition = smithingRecipeInput.method_59984(2);
        boolean flag = true;
        if (!TravelersBackpackConfig.getConfig().backpackSettings.crafting.enableUpgrade) {
            boolean bl = flag = !addition.method_31574(ModItems.CRAFTING_UPGRADE);
        }
        if (!TravelersBackpackConfig.getConfig().backpackSettings.enableTierUpgrades) {
            flag = !addition.method_31574(ModItems.IRON_TIER_UPGRADE) && !addition.method_31574(ModItems.GOLD_TIER_UPGRADE) && !addition.method_31574(ModItems.DIAMOND_TIER_UPGRADE) && !addition.method_31574(ModItems.NETHERITE_TIER_UPGRADE);
        }
        return flag && super.method_59999(smithingRecipeInput, world);
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_UPGRADE;
    }

    public static class Serializer
    implements class_1865<BackpackUpgradeRecipe> {
        private static final MapCodec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("template").forGetter(recipe -> recipe.template), (App)class_1856.field_46095.fieldOf("base").forGetter(recipe -> recipe.base), (App)class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, BackpackUpgradeRecipe::new));
        public static final class_9139<class_9129, BackpackUpgradeRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<BackpackUpgradeRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BackpackUpgradeRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static BackpackUpgradeRecipe read(class_9129 buf) {
            class_1856 ingredient = (class_1856)class_1856.field_48355.decode((Object)buf);
            class_1856 ingredient2 = (class_1856)class_1856.field_48355.decode((Object)buf);
            class_1856 ingredient3 = (class_1856)class_1856.field_48355.decode((Object)buf);
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            return new BackpackUpgradeRecipe(ingredient, ingredient2, ingredient3, itemStack);
        }

        private static void write(class_9129 buf, BackpackUpgradeRecipe recipe) {
            class_1856.field_48355.encode((Object)buf, (Object)recipe.template);
            class_1856.field_48355.encode((Object)buf, (Object)recipe.base);
            class_1856.field_48355.encode((Object)buf, (Object)recipe.addition);
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
        }
    }
}

