/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TimeUtils;
import java.util.Arrays;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final class_1322 NETHERITE_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"netherite_backpack_armor"), 4.0, class_1322.class_1323.field_6328);
    public final class_1322 DIAMOND_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"diamond_backpack_armor"), 3.0, class_1322.class_1323.field_6328);
    public final class_1322 IRON_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"iron_backpack_armor"), 2.0, class_1322.class_1323.field_6328);
    public final class_1322 GOLD_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"gold_backpack_armor"), 2.0, class_1322.class_1323.field_6328);
    public final class_1322 ENDERMAN_REACH_DISTANCE_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"enderman_backpack_reach"), 1.0, class_1322.class_1323.field_6328);
    private static final class_4051 OCELOT_ABILITY_PREDICATE = class_4051.method_36626().method_18418(6.0);
    public static final class_1792[] ALL_ABILITIES_LIST = new class_1792[]{ModItems.NETHERITE_TRAVELERS_BACKPACK, ModItems.DIAMOND_TRAVELERS_BACKPACK, ModItems.GOLD_TRAVELERS_BACKPACK, ModItems.EMERALD_TRAVELERS_BACKPACK, ModItems.IRON_TRAVELERS_BACKPACK, ModItems.LAPIS_TRAVELERS_BACKPACK, ModItems.REDSTONE_TRAVELERS_BACKPACK, ModItems.BOOKSHELF_TRAVELERS_BACKPACK, ModItems.SPONGE_TRAVELERS_BACKPACK, ModItems.CAKE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.MELON_TRAVELERS_BACKPACK, ModItems.PUMPKIN_TRAVELERS_BACKPACK, ModItems.CREEPER_TRAVELERS_BACKPACK, ModItems.DRAGON_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK, ModItems.BLAZE_TRAVELERS_BACKPACK, ModItems.GHAST_TRAVELERS_BACKPACK, ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK, ModItems.SPIDER_TRAVELERS_BACKPACK, ModItems.WITHER_TRAVELERS_BACKPACK, ModItems.BAT_TRAVELERS_BACKPACK, ModItems.BEE_TRAVELERS_BACKPACK, ModItems.OCELOT_TRAVELERS_BACKPACK, ModItems.COW_TRAVELERS_BACKPACK, ModItems.CHICKEN_TRAVELERS_BACKPACK, ModItems.SQUID_TRAVELERS_BACKPACK};
    public static final class_1792[] ITEM_ABILITIES_LIST = new class_1792[]{ModItems.NETHERITE_TRAVELERS_BACKPACK, ModItems.DIAMOND_TRAVELERS_BACKPACK, ModItems.GOLD_TRAVELERS_BACKPACK, ModItems.EMERALD_TRAVELERS_BACKPACK, ModItems.IRON_TRAVELERS_BACKPACK, ModItems.LAPIS_TRAVELERS_BACKPACK, ModItems.CAKE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.PUMPKIN_TRAVELERS_BACKPACK, ModItems.CREEPER_TRAVELERS_BACKPACK, ModItems.DRAGON_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK, ModItems.BLAZE_TRAVELERS_BACKPACK, ModItems.GHAST_TRAVELERS_BACKPACK, ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK, ModItems.SPIDER_TRAVELERS_BACKPACK, ModItems.WITHER_TRAVELERS_BACKPACK, ModItems.BAT_TRAVELERS_BACKPACK, ModItems.BEE_TRAVELERS_BACKPACK, ModItems.OCELOT_TRAVELERS_BACKPACK, ModItems.COW_TRAVELERS_BACKPACK, ModItems.CHICKEN_TRAVELERS_BACKPACK, ModItems.SQUID_TRAVELERS_BACKPACK};
    public static final class_1792[] ITEM_ABILITIES_REMOVAL_LIST = new class_1792[]{ModItems.NETHERITE_TRAVELERS_BACKPACK, ModItems.DIAMOND_TRAVELERS_BACKPACK, ModItems.GOLD_TRAVELERS_BACKPACK, ModItems.IRON_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK};
    public static final class_1792[] ITEM_TIMER_ABILITIES_LIST = new class_1792[]{ModItems.CAKE_TRAVELERS_BACKPACK, ModItems.CREEPER_TRAVELERS_BACKPACK, ModItems.COW_TRAVELERS_BACKPACK, ModItems.CHICKEN_TRAVELERS_BACKPACK};
    public static final class_1792[] BLOCK_TIMER_ABILITIES_LIST = new class_1792[]{ModItems.MELON_TRAVELERS_BACKPACK};
    public static final class_1792[] BLOCK_ABILITIES_LIST = new class_1792[]{ModItems.EMERALD_TRAVELERS_BACKPACK, ModItems.REDSTONE_TRAVELERS_BACKPACK, ModItems.BOOKSHELF_TRAVELERS_BACKPACK, ModItems.SPONGE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.MELON_TRAVELERS_BACKPACK};

    public void abilityTick(@Nullable class_1799 stack, @Nullable class_1657 player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity == null) {
            if (stack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
            }
            if (stack.method_7909() == ModItems.EMERALD_TRAVELERS_BACKPACK) {
                this.emeraldAbility(player, null);
            }
            if (stack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.method_7909() == ModItems.CAKE_TRAVELERS_BACKPACK) {
                this.cakeAbility(player);
            }
            if (stack.method_7909() == ModItems.CACTUS_TRAVELERS_BACKPACK) {
                this.cactusAbility(player, null);
            }
            if (stack.method_7909() == ModItems.DRAGON_TRAVELERS_BACKPACK) {
                this.dragonAbility(player);
            }
            if (stack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            }
            if (stack.method_7909() == ModItems.BLAZE_TRAVELERS_BACKPACK) {
                this.blazeAbility(player);
            }
            if (stack.method_7909() == ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK) {
                this.magmaCubeAbility(player);
            }
            if (stack.method_7909() == ModItems.SPIDER_TRAVELERS_BACKPACK) {
                this.spiderAbility(player);
            }
            if (stack.method_7909() == ModItems.WITHER_TRAVELERS_BACKPACK) {
                this.witherAbility(player);
            }
            if (stack.method_7909() == ModItems.BAT_TRAVELERS_BACKPACK) {
                this.batAbility(player);
            }
            if (stack.method_7909() == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotAbility(player);
            }
            if (stack.method_7909() == ModItems.COW_TRAVELERS_BACKPACK) {
                this.cowAbility(player);
            }
            if (stack.method_7909() == ModItems.CHICKEN_TRAVELERS_BACKPACK) {
                this.chickenAbility(player, false);
            }
            if (stack.method_7909() == ModItems.SQUID_TRAVELERS_BACKPACK) {
                this.squidAbility(player);
            }
        } else {
            class_1792 item = blockEntity.getItemStack().method_7909();
            if (item == ModItems.CACTUS_TRAVELERS_BACKPACK) {
                this.cactusAbility(null, blockEntity);
            }
        }
    }

    public void abilityRemoval(class_1799 stack, class_1657 player) {
        if (stack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
    }

    public void animateTick(TravelersBackpackBlockEntity blockEntity, class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
        if (blockEntity != null && blockEntity.getAbilityValue()) {
            class_2248 block = stateIn.method_26204();
            if (block == ModBlocks.EMERALD_TRAVELERS_BACKPACK) {
                this.emeraldAbility(null, blockEntity);
            }
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK) {
                this.bookshelfAbility(null, blockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                this.spongeAbility(blockEntity);
            }
        }
    }

    public void emeraldAbility(@Nullable class_1657 player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        class_1937 world;
        class_1937 class_19372 = world = player == null ? blockEntity.method_10997() : player.method_37908();
        if (player == null || world.field_9229.method_43048(10) == 1) {
            float f = world.field_9229.method_43057() * (float)Math.PI * 2.0f;
            float f1 = world.field_9229.method_43057() * 0.5f + 0.5f;
            float f2 = class_3532.method_15374((float)f) * 0.5f * f1;
            float f3 = class_3532.method_15362((float)f) * 0.5f * f1;
            world.method_8406((class_2394)class_2398.field_11211, player == null ? (double)((float)blockEntity.method_11016().method_10263() + f2 + 0.5f) : player.method_19538().field_1352 + (double)f2, player == null ? (double)((float)blockEntity.method_11016().method_10264() + world.field_9229.method_43057()) : player.method_5829().field_1322 + (double)world.field_9229.method_43057() + 0.5, player == null ? (double)((float)blockEntity.method_11016().method_10260() + f3 + 0.5f) : player.method_19538().field_1350 + (double)f3, (double)((float)Math.pow(2.0, (double)(world.field_9229.method_43048(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void attributeAbility(class_1657 player, boolean isRemoval, class_6880<class_1320> attribute, class_1322 modifier) {
        class_1324 armor = player.method_5996(attribute);
        if (isRemoval && armor != null && armor.method_6196(modifier.comp_2447())) {
            armor.method_6200(modifier.comp_2447());
        }
        if (!isRemoval && armor != null && !armor.method_6196(modifier.comp_2447())) {
            armor.method_26837(modifier);
        }
    }

    public void armorAbilityRemovals(class_1657 player) {
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
    }

    public void lapisAbility(class_1657 player) {
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.LAPIS_TRAVELERS_BACKPACK)) {
            int number = player.method_59922().method_39332(0, 1);
            player.method_7255(number);
            BackpackAbilities.sendParticlesPacket((class_2394)class_2398.field_28479, player, number);
        }
    }

    public void bookshelfAbility(@Nullable class_1657 player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        class_2338 enchanting = BackpackUtils.findBlock3D(blockEntity.method_10997(), blockEntity.method_11016().method_10263(), blockEntity.method_11016().method_10264(), blockEntity.method_11016().method_10260(), class_2246.field_10485, 2, 2);
        if (enchanting != null) {
            if (!blockEntity.method_10997().method_22347(new class_2338((enchanting.method_10263() - blockEntity.method_11016().method_10263()) / 2 + blockEntity.method_11016().method_10263(), enchanting.method_10264(), (enchanting.method_10260() - blockEntity.method_11016().method_10260()) / 2 + blockEntity.method_11016().method_10260()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                blockEntity.method_10997().method_8406((class_2394)class_2398.field_11215, (double)enchanting.method_10263() + 0.5, (double)enchanting.method_10264() + 2.0, (double)enchanting.method_10260() + 0.5, (double)((float)(blockEntity.method_11016().method_10263() - enchanting.method_10263()) + blockEntity.method_10997().field_9229.method_43057()) - 0.5, (double)((float)(blockEntity.method_11016().method_10264() - enchanting.method_10264()) - blockEntity.method_10997().field_9229.method_43057() - 1.0f), (double)((float)(blockEntity.method_11016().method_10260() - enchanting.method_10260()) + blockEntity.method_10997().field_9229.method_43057()) - 0.5);
            }
        }
    }

    public void spongeAbility(TravelersBackpackBlockEntity blockEntity) {
        if (!blockEntity.getLeftTank().isResourceBlank() && !blockEntity.getRightTank().isResourceBlank() && ((FluidVariant)blockEntity.getLeftTank().getResource()).getFluid().method_15780((class_3611)class_3612.field_15910) && ((FluidVariant)blockEntity.getRightTank().getResource()).getFluid().method_15780((class_3611)class_3612.field_15910) && blockEntity.getLeftTank().getAmount() == blockEntity.getLeftTank().getCapacity() && blockEntity.getRightTank().getAmount() == blockEntity.getRightTank().getCapacity()) {
            float f = blockEntity.method_10997().field_9229.method_43057() * (float)Math.PI * 2.0f;
            float f1 = blockEntity.method_10997().field_9229.method_43057() * 0.5f + 0.5f;
            float f2 = class_3532.method_15374((float)f) * 0.5f * f1;
            float f3 = class_3532.method_15362((float)f) * 0.5f * f1;
            blockEntity.method_10997().method_8406((class_2394)class_2398.field_11202, (double)((float)blockEntity.method_11016().method_10263() + f2 + 0.5f), (double)((float)blockEntity.method_11016().method_10264() + blockEntity.method_10997().field_9229.method_43057()), (double)((float)blockEntity.method_11016().method_10260() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(blockEntity.method_10997().field_9229.method_43048(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(class_1657 player) {
        TravelersBackpackInventory container = ComponentUtils.getBackpackInv(player);
        if (container.getLastTime() <= 0) {
            player.method_7344().method_7585(2, 0.1f);
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_26947, class_3419.field_15256, 1.0f, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.3f + 1.0f);
            if (!player.method_37908().field_9236) {
                class_1937 class_19372 = player.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 server = (class_3218)class_19372;
                    for (int i = 0; i < 3; ++i) {
                        float f = server.field_9229.method_43057() * (float)Math.PI * 2.0f;
                        float f1 = server.field_9229.method_43057() * 0.5f + 0.5f;
                        float f2 = class_3532.method_15374((float)f) * 0.5f * f1;
                        float f3 = class_3532.method_15362((float)f) * 0.5f * f1;
                        server.method_14199((class_2394)class_2398.field_11201, player.method_19538().field_1352 + (double)f2, player.method_5829().field_1322 + (double)player.method_37908().field_9229.method_43057() + 0.5, player.method_19538().field_1350 + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.method_37908().field_9229.method_43048(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                    }
                }
                container.setLastTime(TimeUtils.randomTime(player.method_37908().field_9229, 360, 360 + player.method_7344().method_7586() * 12));
                container.markDataDirty(8);
            }
        }
    }

    public void chickenAbility(class_1657 player, boolean firstSwitch) {
        TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
        if (firstSwitch && inv.getLastTime() <= 0 && !inv.world().field_9236) {
            inv.setLastTime(TimeUtils.randomTime(player.method_37908().field_9229, 360, 600));
            inv.markDataDirty(8);
            return;
        }
        if (inv.getLastTime() <= 0) {
            player.method_37908().method_8396(player, player.method_24515(), class_3417.field_15219, class_3419.field_15256, 1.0f, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.3f + 1.0f);
            player.method_5706((class_1935)class_1802.field_8803);
            if (!inv.world().field_9236) {
                inv.setLastTime(TimeUtils.randomTime(player.method_37908().field_9229, 360, 600));
                inv.markDataDirty(8);
            }
        }
    }

    public void cactusAbility(@Nullable class_1657 player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        ITravelersBackpackInventory inv = player == null ? blockEntity : ComponentUtils.getBackpackInv(player);
        FluidTank leftTank = inv.getLeftTank();
        FluidTank rightTank = inv.getRightTank();
        int drops = 0;
        if (player != null && player.method_5869()) {
            drops += 162;
        }
        if (this.isUnderRain(blockEntity == null ? player.method_24515() : blockEntity.method_11016(), blockEntity == null ? player.method_37908() : blockEntity.method_10997())) {
            drops += 81;
        }
        FluidVariant water = FluidVariant.of((class_3611)class_3612.field_15910);
        if (!inv.world().field_9236 && inv.getLastTime() <= 0 && drops > 0) {
            long amount;
            inv.setLastTime(5);
            try (Transaction transaction = Transaction.openOuter();){
                if ((leftTank.isResourceBlank() || ((FluidVariant)leftTank.getResource()).isOf((Object)water.getFluid())) && (amount = leftTank.insert((TransferVariant)water, drops, (TransactionContext)transaction)) == (long)drops) {
                    transaction.commit();
                }
            }
            transaction = Transaction.openOuter();
            try {
                if ((rightTank.isResourceBlank() || ((FluidVariant)rightTank.getResource()).isOf((Object)water.getFluid())) && (amount = rightTank.insert((TransferVariant)water, drops, (TransactionContext)transaction)) == (long)drops) {
                    transaction.commit();
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
            inv.markDataDirty(4);
        }
    }

    public static void melonAbility(TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && blockEntity.getLastTime() <= 0) {
            class_2248.method_9577((class_1937)blockEntity.method_10997(), (class_2338)blockEntity.method_11016(), (class_1799)new class_1799((class_1935)class_1802.field_8497, blockEntity.method_10997().field_9229.method_43051(0, 3)));
            blockEntity.setLastTime(TimeUtils.randomTime(blockEntity.method_10997().field_9229, 120, 480));
            blockEntity.method_5431();
        }
    }

    public static void pumpkinAbility(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.PUMPKIN_TRAVELERS_BACKPACK)) {
            cir.setReturnValue((Object)false);
        }
    }

    public static boolean creeperAbility(class_1657 player) {
        TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
        if (player.method_29504() && inv != null && inv.getItemStack().method_7909() == ModItems.CREEPER_TRAVELERS_BACKPACK && inv.getAbilityValue() && inv.getLastTime() <= 0) {
            player.method_6033(1.0f);
            player.method_6012();
            player.method_6092(new class_1293(class_1294.field_5924, 450, 1));
            player.method_6092(new class_1293(class_1294.field_5898, 100, 1));
            player.method_6092(new class_1293(class_1294.field_5918, 400, 0));
            player.method_37908().method_55117((class_1297)player, player.method_48923().method_48802(player), null, player.method_23322(0.5), player.method_23318(), player.method_23325(0.5), 3.0f, false, class_1937.class_7867.field_40888);
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15057, class_3419.field_15256, 1.2f, 0.5f);
            if (!inv.world().field_9236) {
                inv.setLastTime(TimeUtils.randomTime(player.method_37908().field_9229, 600, 900));
                inv.markDataDirty(8);
            }
            return true;
        }
        return false;
    }

    public void dragonAbility(class_1657 player) {
        this.magmaCubeAbility(player);
        this.squidAbility(player);
        this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5924, 0, 210, 0, false, false, true);
        this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5910, 210, 240, 0, false, false, true);
    }

    public void blazeAbility(class_1657 player) {
        if (player.field_6017 >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.method_37908().method_8406((class_2394)class_2398.field_11237, player.method_23322(0.5), player.method_23319(), player.method_23325(0.5), 0.0, 0.0, 0.0);
            }
            player.field_6017 = 0.0f;
        }
    }

    public static void blazeAbility(class_3966 result, class_1677 fireball, CallbackInfo ci) {
        class_1657 player;
        class_1297 class_12972 = result.method_17782();
        if (class_12972 instanceof class_1657 && ABILITIES.checkBackpack(player = (class_1657)class_12972, (class_1792)ModItems.BLAZE_TRAVELERS_BACKPACK)) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 0.8f + player.method_37908().field_9229.method_43057() * 0.4f);
            BackpackAbilities.sendParticlesPacket((class_2394)class_2398.field_11240, player, 3);
            fireball.method_31472();
            ci.cancel();
        }
    }

    public static void ghastAbility(class_1571 ghast, class_1309 livingEntity, CallbackInfo ci) {
        class_1657 player;
        if (livingEntity instanceof class_1657 && ABILITIES.checkBackpack(player = (class_1657)livingEntity, (class_1792)ModItems.GHAST_TRAVELERS_BACKPACK) && ghast.method_6065() != player) {
            ci.cancel();
        }
    }

    public void magmaCubeAbility(class_1657 player) {
        this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5918, 210, 240, 0, false, false, true);
    }

    public void spiderAbility(class_1657 player) {
        if (player.field_5976 && !(player.method_55667().method_26204() instanceof class_2404)) {
            if (player.method_6128()) {
                player.method_23670();
            }
            if (!player.method_24828() && player.method_5715()) {
                player.method_18800(player.method_18798().field_1352, 0.0, player.method_18798().field_1350);
            } else {
                player.method_18800(player.method_18798().field_1352, 0.2, player.method_18798().field_1350);
                class_1937 level = player.method_37908();
                class_2680 state = level.method_8320(player.method_24515().method_10093(player.method_5755()));
                player.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, state), player.method_23317() + (level.field_9229.method_43058() - 0.5) * (double)player.method_18377(class_4050.field_18076).comp_2185(), player.method_23318() + 0.1, player.method_23321() + (level.field_9229.method_43058() - 0.5) * (double)player.method_18377(class_4050.field_18076).comp_2185(), 0.0, 1.5, 0.0);
            }
        }
    }

    public void witherAbility(class_1657 player) {
        if (player.method_6112(class_1294.field_5920) != null) {
            player.method_6016(class_1294.field_5920);
        }
    }

    public void batAbility(class_1657 player) {
        this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5925, 210, 240, 0, false, false, true);
    }

    public static void beeAbility(class_1657 player, class_1297 target) {
        class_1282 damageSource;
        boolean flag;
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.BEE_TRAVELERS_BACKPACK) && (flag = target.method_5643(damageSource = player.method_48923().method_48801((class_1309)player), 1.0f))) {
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
            }
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                living.method_21755(living.method_21753() + 1);
                living.method_37222(new class_1293(class_1294.field_5899, 80, 0), (class_1297)player);
            }
        }
    }

    public void ocelotAbility(class_1657 player) {
        if (player.method_37908().method_21726(class_1588.class, OCELOT_ABILITY_PREDICATE, (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1009(6.0, 2.0, 6.0)) != null) {
            this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5904, 20, 30, 0, false, false, true);
        }
    }

    public void cowAbility(class_1657 player) {
        if (!player.method_6088().isEmpty() && ComponentUtils.getBackpackInv(player).getLastTime() <= 0) {
            player.method_6012();
            if (!player.method_37908().field_9236) {
                player.method_37908().method_20290(2007, player.method_24515(), 0xFFFFFF);
            }
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_29543, class_3419.field_15248, 1.0f, player.method_59922().method_43057() * 0.1f + 0.9f);
            ComponentUtils.getBackpackInv(player).setLastTime(TimeUtils.randomTime(player.method_37908().field_9229, 450, 600));
            ComponentUtils.getBackpackInv(player).markDataDirty(8);
        }
    }

    public void squidAbility(class_1657 player) {
        if (player.method_5869()) {
            this.addTimedStatusEffect(player, (class_6880<class_1291>)class_1294.field_5923, 210, 240, 0, false, false, true);
            this.batAbility(player);
        }
    }

    public static void sendParticlesPacket(class_2394 effect, class_1657 player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.method_37908().field_9229.method_43059() * 0.02;
            double d1 = player.method_37908().field_9229.method_43059() * 0.02;
            double d2 = player.method_37908().field_9229.method_43059() * 0.02;
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 server = (class_3218)class_19372;
            server.method_14199(effect, player.method_23322(1.0), player.method_23319() + 0.5, player.method_23325(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public boolean checkBackpack(class_1657 player, class_1792 item) {
        return ComponentUtils.isWearingBackpack(player) && ComponentUtils.getBackpackInv(player).getItemStack().method_7909() == item && ComponentUtils.getBackpackInv(player).getAbilityValue();
    }

    public void addTimedStatusEffect(class_1657 player, class_6880<class_1291> effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.method_6059(effect)) {
            player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.method_6059(effect) && player.method_6112(effect) != null && player.method_6112(effect).method_5584() <= minDuration) {
            player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    private boolean isUnderRain(class_2338 pos, class_1937 world) {
        return world.method_8311(pos) && world.method_8419();
    }

    public static boolean isOnList(class_1792[] list, class_1799 stackToCheck) {
        return Arrays.stream(list).anyMatch(s -> s == stackToCheck.method_7909());
    }
}

