/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen.tooltip;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.BackpackContainerComponent;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.init.ModComponentTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_5632;

public class BackpackTooltipData
implements class_5632 {
    protected List<class_1799> storage = new ArrayList<class_1799>();
    protected List<class_1799> tools = new ArrayList<class_1799>();
    protected List<class_1799> crafting = new ArrayList<class_1799>();
    protected Pair<FluidVariant, Long> leftTank = Pair.of((Object)FluidVariant.blank(), (Object)0L);
    protected Pair<FluidVariant, Long> rightTank = Pair.of((Object)FluidVariant.blank(), (Object)0L);

    public BackpackTooltipData(class_1799 stack) {
        this.loadComponentData(stack);
    }

    public void loadComponentData(class_1799 stack) {
        this.loadFluidStacks(stack);
        this.storage = this.loadInventory(stack);
        this.crafting = this.loadCraftingInventory(stack);
        this.storage.addAll(this.crafting);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(stack);
    }

    public void loadFluidStacks(class_1799 stack) {
        if (stack.method_57826(ModComponentTypes.FLUID_TANKS)) {
            FluidTanks tanks = (FluidTanks)stack.method_57824(ModComponentTypes.FLUID_TANKS);
            this.leftTank = Pair.of((Object)tanks.leftTank().fluidVariant(), (Object)tanks.leftTank().amount());
            this.rightTank = Pair.of((Object)tanks.rightTank().fluidVariant(), (Object)tanks.rightTank().amount());
        }
    }

    public List<class_1799> loadInventory(class_1799 stack) {
        if (stack.method_57826(ModComponentTypes.BACKPACK_CONTAINER)) {
            return new ArrayList<class_1799>(((BackpackContainerComponent)stack.method_57824(ModComponentTypes.BACKPACK_CONTAINER)).getStacks().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }

    public List<class_1799> mergeStacks(List<class_1799> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<class_1799> uniqueList = new ArrayList<class_1799>();
            for (class_1799 stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)uniqueList.get(i)))) continue;
                    int count = stack.method_7947() + ((class_1799)uniqueList.get(i)).method_7947();
                    uniqueList.set(i, stack.method_46651(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<class_1799> splittedList = new ArrayList<class_1799>();
            for (class_1799 itemStack : uniqueList) {
                if (itemStack.method_7947() > 999) {
                    int count = itemStack.method_7947();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.method_46651(999));
                    }
                    splittedList.add(itemStack.method_46651(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return Collections.emptyList();
    }

    public List<class_1799> loadTools(class_1799 stack) {
        if (stack.method_57826(ModComponentTypes.TOOLS_CONTAINER)) {
            return new ArrayList<class_1799>(((BackpackContainerComponent)stack.method_57824(ModComponentTypes.TOOLS_CONTAINER)).getStacks().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }

    public List<class_1799> loadCraftingInventory(class_1799 stack) {
        if (stack.method_57826(ModComponentTypes.CRAFTING_CONTAINER)) {
            return new ArrayList<class_1799>(((BackpackContainerComponent)stack.method_57824(ModComponentTypes.CRAFTING_CONTAINER)).getStacks().stream().filter(itemStack -> !itemStack.method_7960()).toList());
        }
        return new ArrayList<class_1799>();
    }
}

