/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen;

import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1074;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final SingleVariantStorage<FluidVariant> tank;

    public TankScreen(SingleVariantStorage<FluidVariant> tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<class_2561> getTankTooltip(class_1937 world) {
        FluidVariant fluidVariant = (FluidVariant)this.tank.getResource();
        ArrayList<class_2561> tankTips = new ArrayList<class_2561>();
        String fluidName = !fluidVariant.isBlank() ? FluidVariantAttributes.getName((FluidVariant)fluidVariant).getString() : class_1074.method_4662((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object fluidAmount = class_1074.method_4662((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidVariant.isBlank()) {
            float amount = (float)this.tank.getAmount() / 81.0f;
            float capacity = (float)this.tank.getCapacity() / 81.0f;
            fluidAmount = (int)amount + "/" + (int)capacity;
        }
        if (!fluidVariant.isBlank() && fluidVariant.getComponents().method_57846().stream().anyMatch(entry -> ((class_9331)entry.getKey()).equals((Object)class_9334.field_49651))) {
            fluidName = null;
            class_1844 contents = (class_1844)fluidVariant.getComponents().method_57845(class_9334.field_49651).get();
            contents.method_47372(tankTips::add, 1.0f, world.method_54719().method_54748());
        }
        if (fluidName != null) {
            tankTips.add((class_2561)class_2561.method_43470((String)fluidName));
        }
        tankTips.add((class_2561)class_2561.method_43470((String)fluidAmount));
        return tankTips;
    }

    public void drawScreenFluidBar(TravelersBackpackHandledScreen screen, class_332 context) {
        RenderUtils.renderScreenTank(context, this.tank, screen.getX() + this.startX, screen.getY() + this.startY, 0.0, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackHandledScreen screen, int mouseX, int mouseY) {
        return screen.getX() + this.startX <= mouseX && mouseX <= this.startX + this.width + screen.getX() && this.startY + screen.getY() <= mouseY && mouseY <= this.startY + this.height + screen.getY();
    }
}

