/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.tiviacz.travelersbackpack.client.model.BackpackModelData;
import com.tiviacz.travelersbackpack.client.renderer.FluidPart;
import com.tiviacz.travelersbackpack.client.renderer.StackPart;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class BackpackFeatureModel<T extends class_1309>
extends class_572<T> {
    public static final BackpackFeatureModel<?> FEATURE_MODEL = new BackpackFeatureModel(BackpackModelData.createTravelersBackpack(true).method_32109());
    public class_630 mainBody;
    public class_630 tankLeftTop;
    public class_630 tankRightTop;
    public class_630 sleepingBag;
    public class_630 sleepingBagExtras;
    public class_630 villagerNose;
    public class_630 wolfNose;
    public class_630 foxNose;
    public class_630 ocelotNose;
    public class_630 pigNose;
    public StackPart stacks;
    public FluidPart fluids;
    @Nullable
    private class_1799 backpackStack;
    @Nullable
    private class_1309 livingEntity;
    @Nullable
    private class_4597 vertices;

    public BackpackFeatureModel(class_630 rootPart) {
        super(rootPart);
        this.mainBody = rootPart.method_32086("body").method_32086("main_body");
        this.tankLeftTop = rootPart.method_32086("body").method_32086("tankLeftTop");
        this.tankRightTop = rootPart.method_32086("body").method_32086("tankRightTop");
        this.sleepingBag = rootPart.method_32086("body").method_32086("sleepingBag");
        this.sleepingBagExtras = rootPart.method_32086("body").method_32086("sleepingBagExtras");
        this.villagerNose = rootPart.method_32086("body").method_32086("villagerNose");
        this.ocelotNose = rootPart.method_32086("body").method_32086("ocelotNose");
        this.pigNose = rootPart.method_32086("body").method_32086("pigNose");
        this.foxNose = rootPart.method_32086("body").method_32086("foxNose");
        this.wolfNose = rootPart.method_32086("body").method_32086("wolfNose");
        this.stacks = new StackPart(rootPart.method_32086("body").method_32086("stacks"));
        this.fluids = new FluidPart(rootPart.method_32086("body").method_32086("fluids"));
    }

    public void setLivingEntity(class_1309 livingEntity) {
        this.livingEntity = livingEntity;
    }

    public void setVertexConsumerProvider(class_4597 vertices) {
        this.vertices = vertices;
    }

    public void setBackpackStack(class_1799 stack) {
        this.backpackStack = stack;
    }

    public class_1799 getBackpackStack() {
        if (this.backpackStack != null && this.backpackStack.method_7909() instanceof TravelersBackpackItem) {
            return this.backpackStack;
        }
        class_1309 class_13092 = this.livingEntity;
        if (class_13092 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_13092;
            return ComponentUtils.getWearingBackpack(playerEntity);
        }
        return this.livingEntity.method_6118(class_1304.field_6174);
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int rgb) {
        class_1309 class_13092;
        this.sleepingBag.method_22699(matrices, vertices, light, overlay, rgb);
        this.sleepingBagExtras.method_22699(matrices, vertices, light, overlay, rgb);
        this.tankLeftTop.method_22699(matrices, vertices, light, overlay, rgb);
        this.tankRightTop.method_22699(matrices, vertices, light, overlay, rgb);
        this.mainBody.method_22699(matrices, vertices, light, overlay, rgb);
        if (this.livingEntity != null) {
            class_1792 item = this.getBackpackStack().method_7909();
            if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.foxNose.method_22698(matrices, vertices, light, overlay);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
                this.wolfNose.method_22698(matrices, vertices, light, overlay);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                this.villagerNose.method_22698(matrices, vertices, light, overlay);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotNose.method_22698(matrices, vertices, light, overlay);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
                this.pigNose.method_22698(matrices, vertices, light, overlay);
            }
        }
        if ((class_13092 = this.livingEntity) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.vertices != null) {
                if (TravelersBackpackConfig.getConfig().client.renderTools) {
                    this.stacks.prepare(this.getBackpackStack(), player, this.vertices);
                    this.stacks.method_22698(matrices, vertices, light, overlay);
                }
                this.fluids.prepare(this.getBackpackStack(), this.vertices);
                this.fluids.method_22698(matrices, vertices, light, overlay);
            }
        }
    }

    public void setupAngles(class_572<T> model) {
        this.mainBody.method_17138(model.field_3391);
        this.sleepingBag.method_17138(model.field_3391);
        this.sleepingBagExtras.method_17138(model.field_3391);
        this.tankLeftTop.method_17138(model.field_3391);
        this.tankRightTop.method_17138(model.field_3391);
        this.villagerNose.method_17138(model.field_3391);
        this.pigNose.method_17138(model.field_3391);
        this.ocelotNose.method_17138(model.field_3391);
        this.wolfNose.method_17138(model.field_3391);
        this.foxNose.method_17138(model.field_3391);
        if (this.livingEntity instanceof class_1657) {
            this.stacks.method_17138(model.field_3391);
            this.fluids.method_17138(model.field_3391);
        }
    }
}

