/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.tiviacz.travelersbackpack.client.model.BackpackModelData;
import com.tiviacz.travelersbackpack.client.renderer.RenderData;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.Locale;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_630;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class BackpackBlockModel {
    public static final BackpackBlockModel BLOCK_MODEL = new BackpackBlockModel(BackpackModelData.createTravelersBackpack(false).method_32109());
    public class_630 mainBody;
    public class_630 tankLeftTop;
    public class_630 tankRightTop;
    public class_630 sleepingBag;
    public class_630 sleepingBagExtras;
    public class_630 villagerNose;
    public class_630 wolfNose;
    public class_630 foxNose;
    public class_630 ocelotNose;
    public class_630 pigNose;

    public BackpackBlockModel(class_630 rootPart) {
        this.mainBody = rootPart.method_32086("main_body");
        this.tankLeftTop = rootPart.method_32086("tankLeftTop");
        this.tankRightTop = rootPart.method_32086("tankRightTop");
        this.sleepingBag = rootPart.method_32086("sleepingBag");
        this.sleepingBagExtras = rootPart.method_32086("sleepingBagExtras");
        this.villagerNose = rootPart.method_32086("villagerNose");
        this.ocelotNose = rootPart.method_32086("ocelotNose");
        this.pigNose = rootPart.method_32086("pigNose");
        this.foxNose = rootPart.method_32086("foxNose");
        this.wolfNose = rootPart.method_32086("wolfNose");
    }

    public void render(ITravelersBackpackInventory inv, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        class_1792 class_17922 = inv.getItemStack().method_7909();
        if (!(class_17922 instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem item = (TravelersBackpackItem)class_17922;
        class_2960 id = item.getBackpackTexture();
        class_4588 vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
        if (item == ModItems.STANDARD_TRAVELERS_BACKPACK && (inv.hasTileEntity() ? inv.hasColor() : inv.getItemStack().method_57826(class_9334.field_49644))) {
            id = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
            this.mainBody.method_22699(matrices, vertexConsumer, light, overlay, inv.hasTileEntity() ? class_5253.class_5254.method_57174((int)inv.getColor()) : class_5253.class_5254.method_57174((int)((class_9282)inv.getItemStack().method_57824(class_9334.field_49644)).comp_2384()));
            id = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
            this.mainBody.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankLeftTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankRightTop.method_22698(matrices, vertexConsumer, light, overlay);
            if (!inv.isSleepingBagDeployed()) {
                this.sleepingBagExtras.method_22698(matrices, vertexConsumer, light, overlay);
                id = BackpackBlockModel.getSleepingBagTexture(inv.getSleepingBagColor());
                vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
                this.sleepingBag.method_22698(matrices, vertexConsumer, light, overlay);
            }
        } else {
            this.tankLeftTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankRightTop.method_22698(matrices, vertexConsumer, light, overlay);
            if (!inv.isSleepingBagDeployed()) {
                this.sleepingBagExtras.method_22698(matrices, vertexConsumer, light, overlay);
                id = BackpackBlockModel.getSleepingBagTexture(inv.getSleepingBagColor());
                vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
                this.sleepingBag.method_22698(matrices, vertexConsumer, light, overlay);
                id = item.getBackpackTexture();
                vertexConsumer = vertices.getBuffer(class_1921.method_23580((class_2960)id));
            }
            if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.foxNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
                this.wolfNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                this.villagerNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
                this.pigNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK || item == ModItems.SNOW_TRAVELERS_BACKPACK) {
                vertexConsumer = vertices.getBuffer(inv.hasTileEntity() ? class_1921.method_23689((class_2960)item.getBackpackTexture()) : class_1921.method_29379((class_2960)item.getBackpackTexture()));
            }
            this.mainBody.method_22698(matrices, vertexConsumer, light, overlay);
        }
        RenderUtils.renderFluidInTank(inv.getLeftTank(), matrices, vertices, light, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(inv.getRightTank(), matrices, vertices, light, 0.23f, -0.565f, -0.24f);
    }

    public void renderByItem(RenderData renderData, class_4587 matrices, class_4597 consumer, int light, int overlay) {
        TravelersBackpackItem item = (TravelersBackpackItem)renderData.getItemStack().method_7909();
        class_2960 id = item.getBackpackTexture();
        class_4588 vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
        if (renderData.getItemStack().method_57826(class_9334.field_49644) && renderData.getItemStack().method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK) {
            id = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
            this.mainBody.method_22699(matrices, vertexConsumer, light, overlay, class_5253.class_5254.method_57174((int)((class_9282)renderData.getItemStack().method_57824(class_9334.field_49644)).comp_2384()));
            id = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
            this.mainBody.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankLeftTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankRightTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.sleepingBagExtras.method_22698(matrices, vertexConsumer, light, overlay);
            id = BackpackBlockModel.getSleepingBagTexture(renderData.getSleepingBagColor());
            vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
            this.sleepingBag.method_22698(matrices, vertexConsumer, light, overlay);
        } else {
            this.tankLeftTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.tankRightTop.method_22698(matrices, vertexConsumer, light, overlay);
            this.sleepingBagExtras.method_22698(matrices, vertexConsumer, light, overlay);
            id = BackpackBlockModel.getSleepingBagTexture(renderData.getSleepingBagColor());
            vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
            this.sleepingBag.method_22698(matrices, vertexConsumer, light, overlay);
            id = item.getBackpackTexture();
            vertexConsumer = consumer.getBuffer(class_1921.method_23580((class_2960)id));
            if (renderData.getItemStack().method_7909() == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.foxNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (renderData.getItemStack().method_7909() == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (renderData.getItemStack().method_7909() == ModItems.WOLF_TRAVELERS_BACKPACK) {
                this.wolfNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (renderData.getItemStack().method_7909() == ModItems.VILLAGER_TRAVELERS_BACKPACK || renderData.getItemStack().method_7909() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                this.villagerNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (renderData.getItemStack().method_7909() == ModItems.PIG_TRAVELERS_BACKPACK || renderData.getItemStack().method_7909() == ModItems.HORSE_TRAVELERS_BACKPACK) {
                this.pigNose.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (renderData.getItemStack().method_7909() == ModItems.QUARTZ_TRAVELERS_BACKPACK || renderData.getItemStack().method_7909() == ModItems.SNOW_TRAVELERS_BACKPACK) {
                vertexConsumer = consumer.getBuffer(class_1921.method_29379((class_2960)item.getBackpackTexture()));
            }
            this.mainBody.method_22698(matrices, vertexConsumer, light, overlay);
        }
        RenderUtils.renderFluidInTank(renderData.getLeftTank(), matrices, consumer, light, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(renderData.getRightTank(), matrices, consumer, light, 0.23f, -0.565f, -0.24f);
    }

    public static class_2960 getSleepingBagTexture(int color) {
        return class_2960.method_60655((String)"travelersbackpack", (String)("textures/model/bags/" + class_1767.method_7791((int)color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png"));
    }
}

