/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.loot;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.loot.v3.FabricLootTableBuilder;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.fabricmc.fabric.impl.loot.LootUtil;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.class_8490;
import net.minecraft.class_9383;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9383.class})
abstract class ReloadableRegistriesMixin {
    @Unique
    private static final WeakHashMap<class_6903<JsonElement>, class_7225.class_7874> WRAPPERS = new WeakHashMap();

    ReloadableRegistriesMixin() {
    }

    @WrapOperation(method={"reload"}, at={@At(value="INVOKE", target="Lnet/minecraft/registry/ReloadableRegistries$ReloadableWrapperLookup;getOps(Lcom/mojang/serialization/DynamicOps;)Lnet/minecraft/registry/RegistryOps;")})
    private static class_6903<JsonElement> storeOps(@Coerce class_7225.class_7874 registries, DynamicOps<JsonElement> ops, Operation<class_6903<JsonElement>> original) {
        class_6903 created = (class_6903)original.call(new Object[]{registries, ops});
        WRAPPERS.put((class_6903<JsonElement>)created, registries);
        return created;
    }

    @WrapOperation(method={"reload"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenApplyAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static CompletableFuture<class_7780<class_7659>> removeOps(CompletableFuture<List<class_2385<?>>> future, Function<? super List<class_2385<?>>, ? extends class_7780<class_7659>> fn, Executor executor, Operation<CompletableFuture<class_7780<class_7659>>> original, @Local class_6903<JsonElement> ops) {
        return (CompletableFuture)original.call(new Object[]{future.thenApply(v -> {
            WRAPPERS.remove(ops);
            return v;
        }), fn, executor});
    }

    @WrapOperation(method={"method_58278"}, at={@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V")})
    private static <T> void modifyLootTable(Optional<T> optionalTable, Consumer<? super T> action, Operation<Void> original, @Local(argsOnly=true) class_2960 id, @Local(argsOnly=true) class_6903<JsonElement> ops) {
        original.call(new Object[]{optionalTable.map(table -> ReloadableRegistriesMixin.modifyLootTable(table, id, ops)), action});
    }

    @Unique
    private static <T> T modifyLootTable(T value, class_2960 id, class_6903<JsonElement> ops) {
        if (!(value instanceof class_52)) {
            return value;
        }
        class_52 table = (class_52)value;
        if (table == class_52.field_948) {
            return value;
        }
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id);
        class_7225.class_7874 registries = WRAPPERS.get(ops);
        LootTableSource source = LootUtil.SOURCES.get().getOrDefault(id, LootTableSource.DATA_PACK);
        class_52 replacement = ((LootTableEvents.Replace)LootTableEvents.REPLACE.invoker()).replaceLootTable((class_5321<class_52>)key, table, source, registries);
        if (replacement != null) {
            table = replacement;
            source = LootTableSource.REPLACED;
        }
        class_52.class_53 builder = FabricLootTableBuilder.copyOf(table);
        ((LootTableEvents.Modify)LootTableEvents.MODIFY.invoker()).modifyLootTable((class_5321<class_52>)key, builder, source, registries);
        return (T)builder.method_338();
    }

    @Inject(method={"method_58279"}, at={@At(value="RETURN")})
    private static <T> void onLootTablesLoaded(class_8490<T> lootDataType, class_3300 resourceManager, class_6903<JsonElement> registryOps, CallbackInfoReturnable<class_2385<?>> cir) {
        if (lootDataType != class_8490.field_44498) {
            return;
        }
        ((LootTableEvents.Loaded)LootTableEvents.ALL_LOADED.invoker()).onLootTablesLoaded(resourceManager, (class_2378<class_52>)((class_2378)cir.getReturnValue()));
        LootUtil.SOURCES.remove();
    }
}

