/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base;

import java.util.Iterator;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.internal.base.ComponentsInternals;

public abstract class AbstractComponentContainer
implements ComponentContainer {
    public static final String NBT_KEY = "cardinal_components";

    @Override
    public void copyFrom(ComponentContainer other, class_7225.class_7874 registryLookup) {
        for (ComponentKey<?> key : this.keys()) {
            Object theirs = key.getInternal(other);
            Object ours = key.getInternal(this);
            assert (ours != null);
            if (theirs == null || ours.equals(theirs)) continue;
            if (ours instanceof CopyableComponent) {
                CopyableComponent copyable = (CopyableComponent)ours;
                copyable.copyFrom(theirs, registryLookup);
                continue;
            }
            class_2487 tag = new class_2487();
            theirs.writeToNbt(tag, registryLookup);
            ours.readFromNbt(tag, registryLookup);
        }
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10573(NBT_KEY, 9)) {
            class_2499 componentList = tag.method_10554(NBT_KEY, 10);
            for (int i = 0; i < componentList.size(); ++i) {
                Object component;
                class_2487 nbt = componentList.method_10602(i);
                ComponentKey<?> type = ComponentRegistry.get(class_2960.method_60654((String)nbt.method_10558("componentId")));
                if (type == null || (component = type.getInternal(this)) == null) continue;
                component.readFromNbt(nbt, registryLookup);
            }
        } else if (tag.method_10573(NBT_KEY, 10)) {
            class_2487 componentMap = tag.method_10562(NBT_KEY);
            for (ComponentKey<?> key : this.keys()) {
                String keyId = key.getId().toString();
                if (!componentMap.method_10573(keyId, 10)) continue;
                Object component = key.getInternal(this);
                assert (component != null);
                component.readFromNbt(componentMap.method_10562(keyId), registryLookup);
                componentMap.method_10551(keyId);
            }
            ComponentsInternals.logDeserializationWarnings(componentMap.method_10541());
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.hasComponents()) {
            class_2487 componentMap = null;
            class_2487 componentTag = new class_2487();
            for (ComponentKey<?> type : this.keys()) {
                Object component = type.getFromContainer(this);
                component.writeToNbt(componentTag, registryLookup);
                if (componentTag.method_33133()) continue;
                if (componentMap == null) {
                    componentMap = new class_2487();
                    tag.method_10566(NBT_KEY, (class_2520)componentMap);
                }
                componentMap.method_10566(type.getId().toString(), (class_2520)componentTag);
                componentTag = new class_2487();
            }
        }
        return tag;
    }

    public String toString() {
        Iterator<ComponentKey<?>> i = this.keys().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            ComponentKey<?> key = i.next();
            Object value = key.getInternal(this);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

