/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.component;

import java.util.List;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentFactory;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.load.ClientLoadAwareComponent;
import org.ladysnake.cca.api.v3.component.load.ClientUnloadAwareComponent;
import org.ladysnake.cca.api.v3.component.load.ServerLoadAwareComponent;
import org.ladysnake.cca.api.v3.component.load.ServerUnloadAwareComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;
import org.ladysnake.cca.api.v3.util.NbtSerializable;
import org.ladysnake.cca.internal.base.GenericContainerBuilder;
import org.ladysnake.cca.internal.base.asm.AsmGeneratedCallback;
import org.ladysnake.cca.internal.base.asm.StaticComponentPluginBase;

@ApiStatus.NonExtendable
public interface ComponentContainer
extends NbtSerializable {
    public static final ComponentContainer EMPTY = StaticComponentPluginBase.createEmptyContainer();

    @Contract(pure=true)
    public @Unmodifiable Set<ComponentKey<?>> keys();

    @Contract(pure=true)
    public boolean hasComponents();

    @Contract(mutates="this")
    public void copyFrom(ComponentContainer var1, class_7225.class_7874 var2);

    @AsmGeneratedCallback(value=ServerTickingComponent.class)
    public void tickServerComponents();

    @AsmGeneratedCallback(value=ClientTickingComponent.class)
    public void tickClientComponents();

    @AsmGeneratedCallback(value=ServerLoadAwareComponent.class)
    @ApiStatus.Experimental
    public void onServerLoad();

    @AsmGeneratedCallback(value=ServerUnloadAwareComponent.class)
    @ApiStatus.Experimental
    public void onServerUnload();

    @AsmGeneratedCallback(value=ClientLoadAwareComponent.class)
    @ApiStatus.Experimental
    public void onClientLoad();

    @AsmGeneratedCallback(value=ClientUnloadAwareComponent.class)
    @ApiStatus.Experimental
    public void onClientUnload();

    @Nullable
    @ApiStatus.Experimental
    default public ComponentKey<?> getKey(Component component) {
        for (ComponentKey<?> key : this.keys()) {
            if (key.getInternal(this) != component) continue;
            return key;
        }
        return null;
    }

    @Override
    @Contract(mutates="this")
    public void fromTag(class_2487 var1, class_7225.class_7874 var2);

    @Override
    @Contract(mutates="param")
    public class_2487 toTag(class_2487 var1, class_7225.class_7874 var2);

    @ApiStatus.NonExtendable
    public static interface Factory<T> {
        @Contract(value="-> new", pure=true)
        public static Builder<@Nullable Void> builder() {
            return new Builder<Void>(Void.class);
        }

        @Contract(value="_ -> new", pure=true)
        public static <T> Builder<T> builder(Class<T> singleArgClass) {
            return new Builder<T>(singleArgClass);
        }

        @Contract(value="_ -> new")
        public ComponentContainer createContainer(@Nullable T var1);

        public static final class Builder<T>
        extends GenericContainerBuilder<ComponentFactory<T, ?>, Factory<T>> {
            Builder(Class<T> argClass) {
                super(ComponentFactory.class, Factory.class, List.of(argClass), t -> EMPTY);
            }

            @Contract(mutates="this")
            public <C extends Component> Builder<T> component(ComponentKey<C> key, ComponentFactory<T, ? extends C> factory) {
                return this.component(key, key.getComponentClass(), factory);
            }

            @Contract(mutates="this")
            public <C extends Component> Builder<T> component(ComponentKey<? super C> key, Class<C> implClass, ComponentFactory<T, ? extends C> factory) {
                return this.component(key, implClass, factory, Set.of());
            }

            @ApiStatus.Experimental
            @Contract(mutates="this")
            public <C extends Component> Builder<T> component(ComponentKey<? super C> key, Class<C> implClass, ComponentFactory<T, ? extends C> factory, Set<ComponentKey<?>> dependencies) {
                super.component(key, implClass, factory, dependencies);
                return this;
            }

            public Builder<T> factoryNameSuffix(String factoryNameSuffix) {
                super.factoryNameSuffix(factoryNameSuffix);
                return this;
            }

            @Override
            public Factory<T> build() {
                return (Factory)super.build();
            }

            @Deprecated(forRemoval=true)
            public Factory<T> build(@Nullable String factoryNameSuffix) {
                if (factoryNameSuffix != null) {
                    this.factoryNameSuffix(factoryNameSuffix);
                }
                return this.build();
            }
        }
    }
}

