/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import org.dynmap.json.simple.JSONArray;
import org.dynmap.utils.Vector3D;

public class Matrix3D {
    private double m11;
    private double m12;
    private double m13;
    private double m21;
    private double m22;
    private double m23;
    private double m31;
    private double m32;
    private double m33;

    public Matrix3D() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
    }

    public Matrix3D(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public void multiply(Matrix3D mat) {
        double new_m11 = mat.m11 * this.m11 + mat.m12 * this.m21 + mat.m13 * this.m31;
        double new_m12 = mat.m11 * this.m12 + mat.m12 * this.m22 + mat.m13 * this.m32;
        double new_m13 = mat.m11 * this.m13 + mat.m12 * this.m23 + mat.m13 * this.m33;
        double new_m21 = mat.m21 * this.m11 + mat.m22 * this.m21 + mat.m23 * this.m31;
        double new_m22 = mat.m21 * this.m12 + mat.m22 * this.m22 + mat.m23 * this.m32;
        double new_m23 = mat.m21 * this.m13 + mat.m22 * this.m23 + mat.m23 * this.m33;
        double new_m31 = mat.m31 * this.m11 + mat.m32 * this.m21 + mat.m33 * this.m31;
        double new_m32 = mat.m31 * this.m12 + mat.m32 * this.m22 + mat.m33 * this.m32;
        double new_m33 = mat.m31 * this.m13 + mat.m32 * this.m23 + mat.m33 * this.m33;
        this.m11 = new_m11;
        this.m12 = new_m12;
        this.m13 = new_m13;
        this.m21 = new_m21;
        this.m22 = new_m22;
        this.m23 = new_m23;
        this.m31 = new_m31;
        this.m32 = new_m32;
        this.m33 = new_m33;
    }

    public void scale(double s1, double s2, double s3) {
        Matrix3D scalemat = new Matrix3D(s1, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, s3);
        this.multiply(scalemat);
    }

    public void rotateXY(double rot_deg) {
        double rot_rad = Math.toRadians(rot_deg);
        double sin_rot = Math.sin(rot_rad);
        double cos_rot = Math.cos(rot_rad);
        Matrix3D rotmat = new Matrix3D(cos_rot, sin_rot, 0.0, -sin_rot, cos_rot, 0.0, 0.0, 0.0, 1.0);
        this.multiply(rotmat);
    }

    public void rotateXZ(double rot_deg) {
        double rot_rad = Math.toRadians(rot_deg);
        double sin_rot = Math.sin(rot_rad);
        double cos_rot = Math.cos(rot_rad);
        Matrix3D rotmat = new Matrix3D(cos_rot, 0.0, -sin_rot, 0.0, 1.0, 0.0, sin_rot, 0.0, cos_rot);
        this.multiply(rotmat);
    }

    public void rotateYZ(double rot_deg) {
        double rot_rad = Math.toRadians(rot_deg);
        double sin_rot = Math.sin(rot_rad);
        double cos_rot = Math.cos(rot_rad);
        Matrix3D rotmat = new Matrix3D(1.0, 0.0, 0.0, 0.0, cos_rot, sin_rot, 0.0, -sin_rot, cos_rot);
        this.multiply(rotmat);
    }

    public void shearZ(double x_fact, double y_fact) {
        Matrix3D shearmat = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, x_fact, y_fact, 1.0);
        this.multiply(shearmat);
    }

    public final void transform(double[] v) {
        double v1 = this.m11 * v[0] + this.m12 * v[1] + this.m13 * v[2];
        double v2 = this.m21 * v[0] + this.m22 * v[1] + this.m23 * v[2];
        double v3 = this.m31 * v[0] + this.m32 * v[1] + this.m33 * v[2];
        v[0] = v1;
        v[1] = v2;
        v[2] = v3;
    }

    public final void transform(Vector3D v) {
        double v1 = this.m11 * v.x + this.m12 * v.y + this.m13 * v.z;
        double v2 = this.m21 * v.x + this.m22 * v.y + this.m23 * v.z;
        double v3 = this.m31 * v.x + this.m32 * v.y + this.m33 * v.z;
        v.x = v1;
        v.y = v2;
        v.z = v3;
    }

    public final void transform(Vector3D v, Vector3D outv) {
        outv.x = this.m11 * v.x + this.m12 * v.y + this.m13 * v.z;
        outv.y = this.m21 * v.x + this.m22 * v.y + this.m23 * v.z;
        outv.z = this.m31 * v.x + this.m32 * v.y + this.m33 * v.z;
    }

    public String toString() {
        return "[ [" + this.m11 + " " + this.m12 + " " + this.m13 + "] [" + this.m21 + " " + this.m22 + " " + this.m23 + "] [" + this.m31 + " " + this.m32 + " " + this.m33 + "] ]";
    }

    public JSONArray toJSON() {
        JSONArray array = new JSONArray();
        array.add(this.m11);
        array.add(this.m12);
        array.add(this.m13);
        array.add(this.m21);
        array.add(this.m22);
        array.add(this.m23);
        array.add(this.m31);
        array.add(this.m32);
        array.add(this.m33);
        return array;
    }
}

