/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class ImageIOManager {
    public static String preUpdateCommand = null;
    public static String postUpdateCommand = null;
    private static Object imageioLock = new Object();
    public static DynmapCore core;
    private static boolean did_warning;

    private static MapType.ImageFormat validateFormat(MapType.ImageFormat fmt) {
        if (fmt.getEncoding() == MapType.ImageEncoding.WEBP && core.getCWEBPPath() == null) {
            if (!did_warning) {
                Log.warning("Attempt to use WEBP support when not usable: using JPEG");
                did_warning = true;
            }
            fmt = MapType.ImageFormat.FORMAT_JPG;
        }
        return fmt;
    }

    private static void doWEBPEncode(BufferedImage img, MapType.ImageFormat fmt, OutputStream out) throws IOException {
        BufferOutputStream bos = new BufferOutputStream();
        ImageIO.write((RenderedImage)img, "png", bos);
        File tmpfile = File.createTempFile("pngToWebp", "png");
        FileOutputStream fos = new FileOutputStream(tmpfile);
        fos.write(bos.buf, 0, bos.len);
        fos.close();
        File tmpfile2 = File.createTempFile("pngToWebp", "webp");
        ArrayList<String> args = new ArrayList<String>();
        args.add(core.getCWEBPPath());
        if (fmt.getID().endsWith("-l")) {
            args.add("-lossless");
        }
        args.add("-q");
        args.add(Integer.toString((int)fmt.getQuality()));
        args.add(tmpfile.getAbsolutePath());
        args.add("-o");
        args.add(tmpfile2.getAbsolutePath());
        Process pr = Runtime.getRuntime().exec(args.toArray(new String[0]));
        try {
            pr.waitFor();
        }
        catch (InterruptedException ix) {
            throw new IOException("Error waiting for encoder");
        }
        Files.copy((File)tmpfile2, (OutputStream)out);
        out.flush();
        tmpfile.delete();
        tmpfile2.delete();
    }

    private static BufferedImage doWEBPDecode(BufferInputStream buf) throws IOException {
        File tmpfile = File.createTempFile("webpToPng", "webp");
        Files.write((byte[])buf.buffer(), (File)tmpfile);
        File tmpfile2 = File.createTempFile("webpToPng", "png");
        String[] args = new String[]{core.getDWEBPPath(), tmpfile.getAbsolutePath(), "-o", tmpfile2.getAbsolutePath()};
        Process pr = Runtime.getRuntime().exec(args);
        try {
            pr.waitFor();
        }
        catch (InterruptedException ix) {
            throw new IOException("Error waiting for encoder");
        }
        BufferedImage obuf = ImageIO.read(tmpfile2);
        tmpfile.delete();
        tmpfile2.delete();
        return obuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferOutputStream imageIOEncode(BufferedImage img, MapType.ImageFormat fmt) {
        if (ImageIOManager.isRequiredJDKVersion(17, -1, -1)) {
            return ImageIOManager.imageIOEncodeUnsafe(img, fmt);
        }
        Object object = imageioLock;
        synchronized (object) {
            return ImageIOManager.imageIOEncodeUnsafe(img, fmt);
        }
    }

    private static BufferOutputStream imageIOEncodeUnsafe(BufferedImage img, MapType.ImageFormat fmt) {
        BufferOutputStream bos = new BufferOutputStream();
        try {
            ImageIO.setUseCache(false);
            fmt = ImageIOManager.validateFormat(fmt);
            if (fmt.getEncoding() == MapType.ImageEncoding.JPG) {
                WritableRaster raster = img.getRaster();
                WritableRaster newRaster = raster.createWritableChild(0, 0, img.getWidth(), img.getHeight(), 0, 0, new int[]{0, 1, 2});
                DirectColorModel cm = (DirectColorModel)img.getColorModel();
                DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                if (iter.hasNext()) {
                    writer = iter.next();
                }
                if (writer == null) {
                    Log.severe("No JPEG ENCODER - Java VM does not support JPEG encoding");
                    return null;
                }
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(fmt.getQuality());
                ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(rgbBuffer, null, null), iwp);
                writer.dispose();
                rgbBuffer.flush();
            } else if (fmt.getEncoding() == MapType.ImageEncoding.WEBP) {
                ImageIOManager.doWEBPEncode(img, fmt, bos);
            } else {
                ImageIO.write((RenderedImage)img, fmt.getFileExt(), bos);
            }
        }
        catch (IOException iox) {
            Log.info("Error encoding image - " + iox.getMessage());
            return null;
        }
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage imageIODecode(MapStorageTile.TileRead tr) throws IOException {
        if (ImageIOManager.isRequiredJDKVersion(17, -1, -1)) {
            return ImageIOManager.imageIODecodeUnsafe(tr);
        }
        Object object = imageioLock;
        synchronized (object) {
            return ImageIOManager.imageIODecodeUnsafe(tr);
        }
    }

    private static BufferedImage imageIODecodeUnsafe(MapStorageTile.TileRead tr) throws IOException {
        ImageIO.setUseCache(false);
        if (tr.format == MapType.ImageEncoding.WEBP) {
            return ImageIOManager.doWEBPDecode(tr.image);
        }
        return ImageIO.read(tr.image);
    }

    private static boolean isRequiredJDKVersion(int targetMajor, int targetMinor, int targetBuild) {
        String javaVersion = System.getProperty("java.version");
        String[] versionParts = javaVersion.split("\\.");
        if (versionParts.length < 3) {
            return versionParts.length == 1 && targetMinor == -1 && targetBuild == -1 && ImageIOManager.parseInt(versionParts[0], -1) >= targetMajor;
        }
        int major = ImageIOManager.parseInt(versionParts[0], -1);
        int minor = ImageIOManager.parseInt(versionParts[1], -1);
        int build = ImageIOManager.parseInt(versionParts[2], -1);
        return major != -1 && major >= targetMajor && minor != -1 && minor >= targetMinor && build != -1 && build >= targetBuild;
    }

    private static int parseInt(String input, int fallback) {
        int output = fallback;
        try {
            output = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return output;
    }

    static {
        did_warning = false;
    }
}

