/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.hdmap.renderer.RPMicroRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RPSupportFrameRenderer
extends RPMicroRenderer {
    private int frame_txt_side;
    private int frame_txt_edge;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.frame_txt_side = super.getMaximumTextureCount();
        this.frame_txt_edge = this.frame_txt_side + 1;
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return super.getMaximumTextureCount() + 2;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int covermask = 0;
        Object v = ctx.getBlockTileEntityField("cvm");
        if (v instanceof Integer) {
            covermask = (Integer)v;
        }
        RenderPatchFactory rpf = ctx.getPatchFactory();
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getPatch(0.0, 1.001, 1.0, 1.0, 1.001, 1.0, 0.0, 1.001, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 2) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        list.add(rpf.getPatch(0.0, -0.001, 1.0, 1.0, -0.001, 1.0, 0.0, -0.001, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 1) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        list.add(rpf.getPatch(-0.001, 0.0, 0.0, -0.001, 0.0, 1.0, -0.001, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 0x10) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        list.add(rpf.getPatch(1.001, 0.0, 1.0, 1.001, 0.0, 0.0, 1.001, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 0x20) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        list.add(rpf.getPatch(1.0, 0.0, -0.001, 0.0, 0.0, -0.001, 1.0, 1.0, -0.001, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 4) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        list.add(rpf.getPatch(0.0, 0.0, 1.001, 1.0, 0.0, 1.001, 0.0, 1.0, 1.001, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, (covermask & 8) != 0 ? this.frame_txt_edge : this.frame_txt_side));
        if ((covermask & 0x3FFFFFFF) != 0) {
            RenderPatch[] rp = super.getRenderPatchList(ctx);
            for (int i = 0; i < rp.length; ++i) {
                list.add(rp[i]);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }
}

