/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v120_2;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v120_2.AsyncChunkProvider120_2;
import org.dynmap.bukkit.helper.v120_2.NBT;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;

public class MapChunkCache120_2
extends GenericMapChunkCache {
    private static final AsyncChunkProvider120_2 provider = BukkitVersionHelper.helper.isUnsafeAsync() ? null : new AsyncChunkProvider120_2();
    private World w;

    public MapChunkCache120_2(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected Supplier<GenericChunk> getLoadedChunkAsync(DynmapChunk chunk) {
        Supplier<NBTTagCompound> supplier = provider.getLoadedChunk((CraftWorld)this.w, chunk.x, chunk.z);
        return () -> {
            NBTTagCompound nbt = (NBTTagCompound)supplier.get();
            return nbt != null ? this.parseChunkFromNBT(new NBT.NBTCompound(nbt)) : null;
        };
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        if (!cw.isChunkLoaded(chunk.x, chunk.z)) {
            return null;
        }
        Chunk c = cw.getHandle().getChunkIfLoaded(chunk.x, chunk.z);
        if (c == null || !c.q) {
            return null;
        }
        NBTTagCompound nbt = ChunkRegionLoader.a((WorldServer)cw.getHandle(), (IChunkAccess)c);
        return nbt != null ? this.parseChunkFromNBT(new NBT.NBTCompound(nbt)) : null;
    }

    @Override
    protected Supplier<GenericChunk> loadChunkAsync(DynmapChunk chunk) {
        try {
            CompletableFuture<NBTTagCompound> nbt = provider.getChunk(((CraftWorld)this.w).getHandle(), chunk.x, chunk.z);
            return () -> {
                NBTTagCompound compound;
                try {
                    compound = (NBTTagCompound)nbt.get();
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                return compound == null ? null : this.parseChunkFromNBT(new NBT.NBTCompound(compound));
            };
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return () -> null;
        }
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        ChunkCoordIntPair cc = new ChunkCoordIntPair(chunk.x, chunk.z);
        GenericChunk gc = null;
        try {
            nbt = (NBTTagCompound)((Optional)cw.getHandle().k().a.e(cc).join()).get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        super.setChunks(dw, chunks);
    }

    @Override
    public int getFoliageColor(BiomeMap bm, int[] colormap, int x, int z) {
        return bm.getBiomeObject().map(BiomeBase::h).flatMap(BiomeFog::e).orElse(colormap[bm.biomeLookup()]);
    }

    @Override
    public int getGrassColor(BiomeMap bm, int[] colormap, int x, int z) {
        BiomeFog fog = bm.getBiomeObject().map(BiomeBase::h).orElse(null);
        if (fog == null) {
            return colormap[bm.biomeLookup()];
        }
        return fog.g().a((double)x, (double)z, fog.f().orElse(colormap[bm.biomeLookup()]).intValue());
    }
}

