/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v119_3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.dynmap.MapManager;

public class AsyncChunkProvider119_3 {
    private final Method getChunk;
    private final Method getAsyncSaveData;
    private final Method save;
    private final Enum<?> data;
    private final Enum<?> priority;
    private int currTick = MinecraftServer.currentTick;
    private int currChunks = 0;

    AsyncChunkProvider119_3() {
        try {
            Method getChunk1 = null;
            Method getAsyncSaveData1 = null;
            Method save1 = null;
            Object priority1 = null;
            Object data1 = null;
            try {
                Class<?> threadClass = Class.forName("io.papermc.paper.chunk.system.io.RegionFileIOThread");
                Class dataclass = Arrays.stream(threadClass.getDeclaredClasses()).filter(c -> c.getSimpleName().equals("RegionFileType")).findAny().orElseThrow(NullPointerException::new);
                data1 = Enum.valueOf((Class)this.cast(dataclass), "CHUNK_DATA");
                Class priorityClass = Arrays.stream(Class.forName("ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor").getClasses()).filter(c -> c.getSimpleName().equals("Priority")).findAny().orElseThrow(NullPointerException::new);
                priority1 = Enum.valueOf((Class)this.cast(priorityClass), "LOWEST");
                getAsyncSaveData1 = ChunkRegionLoader.class.getMethod("getAsyncSaveData", WorldServer.class, IChunkAccess.class);
                save1 = ChunkRegionLoader.class.getMethod("saveChunk", WorldServer.class, IChunkAccess.class, getAsyncSaveData1.getReturnType());
                getChunk1 = threadClass.getMethod("loadDataAsync", WorldServer.class, Integer.TYPE, Integer.TYPE, data1.getClass(), BiConsumer.class, Boolean.TYPE, priority1.getClass());
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            this.getAsyncSaveData = Objects.requireNonNull(getAsyncSaveData1);
            this.save = Objects.requireNonNull(save1);
            this.getChunk = Objects.requireNonNull(getChunk1);
            this.data = Objects.requireNonNull(data1);
            this.priority = Objects.requireNonNull(priority1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private <T> T cast(Object o) {
        return (T)o;
    }

    public CompletableFuture<NBTTagCompound> getChunk(WorldServer world, int x, int y) throws InvocationTargetException, IllegalAccessException {
        CompletableFuture<NBTTagCompound> future = new CompletableFuture<NBTTagCompound>();
        this.getChunk.invoke(null, world, x, y, this.data, (nbt, exception) -> future.complete((NBTTagCompound)nbt), true, this.priority);
        return future;
    }

    public synchronized Supplier<NBTTagCompound> getLoadedChunk(CraftWorld world, int x, int z) {
        if (!world.isChunkLoaded(x, z)) {
            return () -> null;
        }
        Chunk c = world.getHandle().getChunkIfLoaded(x, z);
        if (c == null || !c.o) {
            return () -> null;
        }
        if (this.currTick != MinecraftServer.currentTick) {
            this.currTick = MinecraftServer.currentTick;
            this.currChunks = 0;
        }
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
            if (!Bukkit.isPrimaryThread()) {
                return null;
            }
            try {
                return this.getAsyncSaveData.invoke(null, world.getHandle(), c);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)((CraftServer)Bukkit.getServer()).getServer());
        if (++this.currChunks > MapManager.mapman.getMaxChunkLoadsPerTick()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return () -> {
            Object o = null;
            try {
                o = future.get();
                return (NBTTagCompound)this.save.invoke(null, world.getHandle(), c, o);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                if (o == null) {
                    return null;
                }
                throw new RuntimeException(e);
            }
            catch (ReflectiveOperationException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

