/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v116_4;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeFog;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkRegionLoader;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v116_4.BukkitVersionHelperSpigot116_4;
import org.dynmap.bukkit.helper.v116_4.NBT;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;

public class MapChunkCache116_4
extends GenericMapChunkCache {
    private World w;

    public MapChunkCache116_4(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        GenericChunk gc = null;
        if (cw.isChunkLoaded(chunk.x, chunk.z)) {
            Chunk c = cw.getHandle().getChunkAt(chunk.x, chunk.z);
            if (c != null && c.loaded) {
                nbt = ChunkRegionLoader.saveChunk((WorldServer)cw.getHandle(), (IChunkAccess)c);
            }
            if (nbt != null) {
                gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
            }
        }
        return gc;
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        ChunkCoordIntPair cc = new ChunkCoordIntPair(chunk.x, chunk.z);
        GenericChunk gc = null;
        try {
            nbt = cw.getHandle().getChunkProvider().playerChunkMap.read(cc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        super.setChunks(dw, chunks);
    }

    @Override
    public int getFoliageColor(BiomeMap bm, int[] colormap, int x, int z) {
        Optional<Object> base = bm.getBiomeObject();
        return BukkitVersionHelperSpigot116_4.getBiomeBaseFoliageMult(base.orElse(null)).orElse(colormap[bm.biomeLookup()]);
    }

    @Override
    public int getGrassColor(BiomeMap bm, int[] colormap, int x, int z) {
        BiomeBase base = bm.getBiomeObject().orElse(null);
        if (base == null) {
            return bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
        }
        int grassMult = BukkitVersionHelperSpigot116_4.getBiomeBaseGrassMult(base).orElse(colormap[bm.biomeLookup()]);
        BiomeFog.GrassColor modifier = BukkitVersionHelperSpigot116_4.getBiomeBaseGrassModifier(base);
        if (modifier == BiomeFog.GrassColor.DARK_FOREST) {
            return (grassMult & 0xFEFEFE) + 2634762 >> 1;
        }
        if (modifier == BiomeFog.GrassColor.SWAMP) {
            double var5 = BiomeBase.f.a((double)x * 0.0225, (double)z * 0.0225, false);
            return var5 < -0.1 ? 5011004 : 6975545;
        }
        return grassMult;
    }
}

