/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.hdmap.HDShader;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.RectangleVisibilityLimit;
import org.dynmap.utils.RoundVisibilityLimit;
import org.dynmap.utils.VisibilityLimit;

public class DynmapMapCommands {
    private Map<String, Map<String, Supplier<String[]>>> tabCompletions = null;

    private void initTabCompletions() {
        String[] emptyValue = new String[]{};
        String[] booleanValue = new String[]{"true", "false"};
        String[] hideStyles = (String[])Arrays.stream(MapChunkCache.HiddenChunkStyle.values()).map(MapChunkCache.HiddenChunkStyle::getValue).toArray(String[]::new);
        String[] perspectives = MapManager.mapman.hdmapman.perspectives.keySet().toArray(new String[0]);
        String[] shaders = MapManager.mapman.hdmapman.shaders.keySet().toArray(new String[0]);
        String[] lightings = MapManager.mapman.hdmapman.lightings.keySet().toArray(new String[0]);
        String[] imageFormats = (String[])Arrays.stream(MapType.ImageFormat.values()).map(MapType.ImageFormat::getID).toArray(String[]::new);
        Supplier<String[]> emptySupplier = () -> emptyValue;
        Supplier<String[]> booleanSupplier = () -> booleanValue;
        Supplier<String[]> hideStyleSupplier = () -> hideStyles;
        Supplier<String[]> perspectiveSupplier = () -> perspectives;
        Supplier<String[]> shaderSupplier = () -> shaders;
        Supplier<String[]> lightingSupplier = () -> lightings;
        Supplier<String[]> imageFormatSupplier = () -> imageFormats;
        LinkedHashMap<String, Supplier<String[]>> worldSetArgs = new LinkedHashMap<String, Supplier<String[]>>();
        worldSetArgs.put("enabled", booleanSupplier);
        worldSetArgs.put("title", emptySupplier);
        worldSetArgs.put("order", emptySupplier);
        worldSetArgs.put("center", emptySupplier);
        worldSetArgs.put("sendposition", booleanSupplier);
        worldSetArgs.put("sendhealth", booleanSupplier);
        worldSetArgs.put("showborder", booleanSupplier);
        worldSetArgs.put("protected", booleanSupplier);
        worldSetArgs.put("extrazoomout", emptySupplier);
        worldSetArgs.put("tileupdatedelay", emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> worldAddLimitArgs = new LinkedHashMap<String, Supplier<String[]>>();
        worldAddLimitArgs.put("type", () -> new String[]{"round", "rect"});
        worldAddLimitArgs.put("limittype", () -> new String[]{"visible", "hidden"});
        worldAddLimitArgs.put("style", hideStyleSupplier);
        worldAddLimitArgs.put("corner1", emptySupplier);
        worldAddLimitArgs.put("corner2", emptySupplier);
        worldAddLimitArgs.put("center", emptySupplier);
        worldAddLimitArgs.put("radius", emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> mapSetArgs = new LinkedHashMap<String, Supplier<String[]>>();
        mapSetArgs.put("title", emptySupplier);
        mapSetArgs.put("icon", emptySupplier);
        mapSetArgs.put("order", emptySupplier);
        mapSetArgs.put("prefix", emptySupplier);
        mapSetArgs.put("perspective", perspectiveSupplier);
        mapSetArgs.put("shader", shaderSupplier);
        mapSetArgs.put("lighting", lightingSupplier);
        mapSetArgs.put("img-format", imageFormatSupplier);
        mapSetArgs.put("protected", booleanSupplier);
        mapSetArgs.put("append-to-world", emptySupplier);
        mapSetArgs.put("mapzoomin", emptySupplier);
        mapSetArgs.put("mapzoomout", emptySupplier);
        mapSetArgs.put("boostzoom", emptySupplier);
        mapSetArgs.put("tilescale", emptySupplier);
        mapSetArgs.put("tileupdatedelay", emptySupplier);
        mapSetArgs.put("readonly", booleanSupplier);
        this.tabCompletions = new HashMap<String, Map<String, Supplier<String[]>>>();
        this.tabCompletions.put("worldaddlimit", worldAddLimitArgs);
        this.tabCompletions.put("worldset", worldSetArgs);
        this.tabCompletions.put("mapset", mapSetArgs);
    }

    private boolean checkIfActive(DynmapCore core, DynmapCommandSender sender) {
        if (!core.getPauseFullRadiusRenders() || !core.getPauseUpdateRenders()) {
            sender.sendMessage("Cannot edit map data while rendering active - run '/dynmap pause all' to pause rendering");
            return true;
        }
        return false;
    }

    public boolean processCommand(DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapCore core) {
        if ((args = DynmapCore.parseArgs(args, sender)).length < 1) {
            return false;
        }
        cmd = args[0];
        boolean rslt = false;
        boolean edit = false;
        if (cmd.equalsIgnoreCase("worldlist")) {
            rslt = this.handleWorldList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("perspectivelist")) {
            rslt = this.handlePerspectiveList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("shaderlist")) {
            rslt = this.handleShaderList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("lightinglist")) {
            rslt = this.handleLightingList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("maplist")) {
            rslt = this.handleMapList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("blocklist")) {
            rslt = this.handleBlockList(sender, args, core);
        } else if (cmd.equalsIgnoreCase("worldgetlimits")) {
            rslt = this.handleWorldGetLimits(sender, args, core);
        } else if (cmd.equalsIgnoreCase("worldremovelimit")) {
            edit = true;
            rslt = this.handleWorldRemoveLimit(sender, args, core);
        } else if (cmd.equalsIgnoreCase("worldaddlimit")) {
            edit = true;
            rslt = this.handleWorldAddLimit(sender, args, core);
        } else if (cmd.equalsIgnoreCase("worldset")) {
            edit = true;
            rslt = this.handleWorldSet(sender, args, core);
        } else if (cmd.equalsIgnoreCase("mapdelete")) {
            edit = true;
            rslt = this.handleMapDelete(sender, args, core);
        } else if (cmd.equalsIgnoreCase("worldreset")) {
            edit = true;
            rslt = this.handleWorldReset(sender, args, core);
        } else if (cmd.equalsIgnoreCase("mapset")) {
            edit = true;
            rslt = this.handleMapSet(sender, args, core, false);
        } else if (cmd.equalsIgnoreCase("mapadd")) {
            edit = true;
            rslt = this.handleMapSet(sender, args, core, true);
        }
        if (edit && rslt) {
            sender.sendMessage("If you are done editing map data, run '/dynmap pause none' to resume rendering");
        }
        return rslt;
    }

    public List<String> getTabCompletions(DynmapCommandSender sender, String[] args, DynmapCore core) {
        String cmd;
        if ((args = DynmapCore.parseArgs(args, sender, true)) == null || args.length <= 1) {
            return Collections.emptyList();
        }
        if (this.tabCompletions == null) {
            this.initTabCompletions();
        }
        if ((cmd = args[0]).equalsIgnoreCase("worldlist") && core.checkPlayerPermission(sender, "dmap.worldlist")) {
            List<String> suggestions = core.getWorldSuggestions(args[args.length - 1]);
            suggestions.removeAll(Arrays.asList(args));
            return suggestions;
        }
        if (cmd.equalsIgnoreCase("maplist") && core.checkPlayerPermission(sender, "dmap.maplist") || cmd.equalsIgnoreCase("worldgetlimits") && core.checkPlayerPermission(sender, "dmap.worldlist")) {
            if (args.length == 2) {
                return core.getWorldSuggestions(args[1]);
            }
        } else if (cmd.equalsIgnoreCase("worldremovelimit") && core.checkPlayerPermission(sender, "dmap.worldset")) {
            if (args.length == 2) {
                return core.getWorldSuggestions(args[1]);
            }
        } else {
            if (cmd.equalsIgnoreCase("worldaddlimit") && core.checkPlayerPermission(sender, "dmap.worldset")) {
                if (args.length == 2) {
                    return core.getWorldSuggestions(args[1]);
                }
                return core.getFieldValueSuggestions(args, this.tabCompletions.get("worldaddlimit"));
            }
            if (cmd.equalsIgnoreCase("worldset") && core.checkPlayerPermission(sender, "dmap.worldset")) {
                if (args.length == 2) {
                    return core.getWorldSuggestions(args[1]);
                }
                return core.getFieldValueSuggestions(args, this.tabCompletions.get("worldset"));
            }
            if (cmd.equalsIgnoreCase("mapdelete") && core.checkPlayerPermission(sender, "dmap.mapdelete")) {
                if (args.length == 2) {
                    return core.getMapSuggestions(args[1]);
                }
            } else if (cmd.equalsIgnoreCase("worldreset") && core.checkPlayerPermission(sender, "dmap.worldreset")) {
                if (args.length == 2) {
                    return core.getWorldSuggestions(args[1]);
                }
            } else {
                if (cmd.equalsIgnoreCase("mapset") && core.checkPlayerPermission(sender, "dmap.mapset")) {
                    if (args.length == 2) {
                        return core.getMapSuggestions(args[1]);
                    }
                    return core.getFieldValueSuggestions(args, this.tabCompletions.get("mapset"));
                }
                if (cmd.equalsIgnoreCase("mapadd") && args.length > 2) {
                    return core.getFieldValueSuggestions(args, this.tabCompletions.get("mapset"));
                }
            }
        }
        return Collections.emptyList();
    }

    private boolean handleWorldList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.worldlist")) {
            return true;
        }
        HashSet<String> wnames = null;
        if (args.length > 1) {
            wnames = new HashSet<String>();
            for (int i = 1; i < args.length; ++i) {
                wnames.add(DynmapWorld.normalizeWorldName(args[i]));
            }
        }
        for (DynmapWorld w : core.getMapManager().getWorlds()) {
            if (wnames != null && !wnames.contains(w.getName())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("world ").append(w.getName()).append(": loaded=").append(w.isLoaded()).append(", enabled=").append(w.isEnabled());
            sb.append(", title=").append(w.getTitle());
            DynmapLocation loc = w.getCenterLocation();
            if (loc != null) {
                sb.append(", center=").append(loc.x).append("/").append(loc.y).append("/").append(loc.z);
            }
            sb.append(", extrazoomout=").append(w.getExtraZoomOutLevels()).append(", sendhealth=").append(w.sendhealth);
            sb.append(", sendposition=").append(w.sendposition);
            sb.append(", protected=").append(w.is_protected);
            sb.append(", showborder=").append(w.showborder);
            if (w.tileupdatedelay > 0) {
                sb.append(", tileupdatedelay=").append(w.tileupdatedelay);
            }
            sender.sendMessage(sb.toString());
        }
        for (String wn : core.getMapManager().getDisabledWorlds()) {
            if (wnames != null && !wnames.contains(wn)) continue;
            sender.sendMessage("world " + wn + ": isenabled=false");
        }
        return true;
    }

    private boolean handleWorldGetLimits(DynmapCommandSender sender, String[] args, DynmapCore core) {
        VisibilityLimit rlimit;
        VisibilityLimit limit;
        int i;
        if (!core.checkPlayerPermission(sender, "dmap.worldlist")) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("World ID required");
            return true;
        }
        String world_id = args[1];
        DynmapWorld w = core.getMapManager().getWorld(world_id);
        if (w == null) {
            sender.sendMessage(String.format("World %s not found", world_id));
            return true;
        }
        sender.sendMessage("limits:");
        int viscnt = 0;
        if (w.visibility_limits != null && w.visibility_limits.size() > 0) {
            viscnt = w.visibility_limits.size();
            for (i = 0; i < viscnt; ++i) {
                limit = w.visibility_limits.get(i);
                if (limit instanceof RoundVisibilityLimit) {
                    rlimit = (RoundVisibilityLimit)limit;
                    sender.sendMessage(String.format(" %d: limittype=visible, type=round, center=%d/%d, radius=%d", i, rlimit.x_center, rlimit.z_center, rlimit.radius));
                    continue;
                }
                if (!(limit instanceof RectangleVisibilityLimit)) continue;
                rlimit = (RectangleVisibilityLimit)limit;
                sender.sendMessage(String.format(" %d: limittype=visible, type=rect, corner1=%d/%d, corner2=%d/%d", i, ((RectangleVisibilityLimit)rlimit).x_min, ((RectangleVisibilityLimit)rlimit).z_min, ((RectangleVisibilityLimit)rlimit).x_max, ((RectangleVisibilityLimit)rlimit).z_max));
            }
        }
        if (w.hidden_limits != null && w.hidden_limits.size() > 0) {
            for (i = 0; i < w.hidden_limits.size(); ++i) {
                limit = w.hidden_limits.get(i);
                if (limit instanceof RoundVisibilityLimit) {
                    rlimit = (RoundVisibilityLimit)limit;
                    sender.sendMessage(String.format(" %d: limittype=hidden, type=round, center=%d/%d, radius=%d", i + viscnt, rlimit.x_center, rlimit.z_center, rlimit.radius));
                    continue;
                }
                if (!(limit instanceof RectangleVisibilityLimit)) continue;
                rlimit = (RectangleVisibilityLimit)limit;
                sender.sendMessage(String.format(" %d: limittype=hidden, type=rect, corner1=%d/%d, corner2=%d/%d", i + viscnt, ((RectangleVisibilityLimit)rlimit).x_min, ((RectangleVisibilityLimit)rlimit).z_min, ((RectangleVisibilityLimit)rlimit).x_max, ((RectangleVisibilityLimit)rlimit).z_max));
            }
        }
        sender.sendMessage("hiddenstyle: " + w.hiddenchunkstyle.getValue());
        return true;
    }

    private boolean handleWorldAddLimit(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.worldset")) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("World ID required");
            return true;
        }
        if (this.checkIfActive(core, sender)) {
            return true;
        }
        String world_id = args[1];
        DynmapWorld w = core.getMapManager().getWorld(world_id);
        if (w == null) {
            sender.sendMessage(String.format("World %s not found", world_id));
            return true;
        }
        String limittype = "visible";
        String type = "rect";
        int[] corner1 = null;
        int[] corner2 = null;
        int[] center = null;
        int radius = 0;
        MapChunkCache.HiddenChunkStyle style = null;
        block26: for (int argid = 2; argid < args.length; ++argid) {
            String[] argval = args[argid].split(":");
            if (argval.length != 2) {
                sender.sendMessage("Argument witout value: " + args[argid]);
                return false;
            }
            String id = argval[0];
            String val = argval[1];
            switch (id) {
                case "type": {
                    if (val.equals("round") || val.equals("rect")) {
                        type = val;
                        continue block26;
                    }
                    sender.sendMessage("Bad type value: " + val);
                    return false;
                }
                case "limittype": {
                    if (val.equals("visible") || val.equals("hidden")) {
                        limittype = val;
                        continue block26;
                    }
                    sender.sendMessage("Bad limittype value: " + val);
                    return false;
                }
                case "corner1": 
                case "corner2": 
                case "center": {
                    if (type.equals("rect") && id.equals("center") || type.equals("round") && !id.equals("center")) {
                        sender.sendMessage("Bad parameter for type " + type + ": " + id);
                        return false;
                    }
                    String[] toks = val.split("/");
                    if (toks.length == 2) {
                        int x = 0;
                        int z = 0;
                        x = Integer.valueOf(toks[0]);
                        z = Integer.valueOf(toks[1]);
                        switch (id) {
                            case "corner1": {
                                corner1 = new int[]{x, z};
                                break;
                            }
                            case "corner2": {
                                corner2 = new int[]{x, z};
                                break;
                            }
                            case "center": {
                                center = new int[]{x, z};
                            }
                        }
                        continue block26;
                    }
                    sender.sendMessage("Bad value for parameter " + id + ": " + val);
                    return false;
                }
                case "radius": {
                    if (!type.equals("round")) {
                        sender.sendMessage("Bad parameter for type " + type + ": " + id);
                        return false;
                    }
                    radius = Integer.valueOf(val);
                    continue block26;
                }
                case "style": {
                    style = MapChunkCache.HiddenChunkStyle.fromValue(val);
                    if (style != null) continue block26;
                    sender.sendMessage("Bad parameter for style: " + val);
                    return false;
                }
                default: {
                    sender.sendMessage("Bad parameter: " + id);
                    return false;
                }
            }
        }
        VisibilityLimit newlimit = null;
        if (type.contentEquals("rect") && corner1 != null && corner2 != null) {
            newlimit = new RectangleVisibilityLimit((int)corner1[0], (int)corner1[1], (int)corner2[0], (int)corner2[1]);
        } else if (type.contentEquals("round") && center != null && (double)radius > 0.0) {
            newlimit = new RoundVisibilityLimit((int)center[0], (int)center[1], radius);
        }
        boolean updated = false;
        if (newlimit != null) {
            if (limittype.contentEquals("visible")) {
                if (w.visibility_limits == null) {
                    w.visibility_limits = new ArrayList<VisibilityLimit>();
                }
                w.visibility_limits.add(newlimit);
            } else {
                if (w.hidden_limits == null) {
                    w.hidden_limits = new ArrayList<VisibilityLimit>();
                }
                w.hidden_limits.add(newlimit);
            }
            updated = true;
        }
        if (style != null) {
            w.hiddenchunkstyle = style;
            updated = true;
        }
        if (updated) {
            core.updateWorldConfig(w);
            sender.sendMessage("Refreshing configuration for world " + world_id);
            core.refreshWorld(world_id);
        }
        return true;
    }

    private boolean handleWorldRemoveLimit(DynmapCommandSender sender, String[] args, DynmapCore core) {
        int viscnt;
        if (!core.checkPlayerPermission(sender, "dmap.worldset")) {
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("World ID and limit index required");
            return true;
        }
        if (this.checkIfActive(core, sender)) {
            return true;
        }
        String world_id = args[1];
        DynmapWorld w = core.getMapManager().getWorld(world_id);
        if (w == null) {
            sender.sendMessage(String.format("World %s not found", world_id));
            return true;
        }
        boolean updated = false;
        String idx = args[2];
        int idxnum = Integer.valueOf(idx);
        int n = viscnt = w.visibility_limits != null ? w.visibility_limits.size() : 0;
        if (idxnum >= 0 && idxnum < viscnt) {
            w.visibility_limits.remove(idxnum);
            if (w.visibility_limits.size() == 0) {
                w.visibility_limits = null;
            }
            updated = true;
        } else if ((idxnum -= viscnt) >= 0 && w.hidden_limits != null && idxnum < w.hidden_limits.size()) {
            w.hidden_limits.remove(idxnum);
            if (w.hidden_limits.size() == 0) {
                w.hidden_limits = null;
            }
            updated = true;
        }
        if (updated) {
            core.updateWorldConfig(w);
            sender.sendMessage("Refreshing configuration for world " + world_id);
            core.refreshWorld(world_id);
        }
        return true;
    }

    private boolean handleWorldSet(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.worldset")) {
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("World name and setting:newvalue required");
            return true;
        }
        String wname = args[1];
        if (this.checkIfActive(core, sender)) {
            return true;
        }
        DynmapWorld w = core.getWorld(wname);
        boolean did_update = false;
        for (int i = 2; i < args.length; ++i) {
            String[] tok = args[i].split(":");
            if (tok.length != 2) {
                sender.sendMessage("Syntax error: " + args[i]);
                return false;
            }
            if (tok[0].equalsIgnoreCase("enabled")) {
                did_update |= core.setWorldEnable(wname, !tok[1].equalsIgnoreCase("false"));
                continue;
            }
            if (tok[0].equalsIgnoreCase("title")) {
                if (w == null) {
                    sender.sendMessage("Cannot set extrazoomout on disabled or undefined world");
                    return true;
                }
                w.setTitle(tok[1]);
                core.updateWorldConfig(w);
                did_update = true;
                continue;
            }
            if (tok[0].equalsIgnoreCase("sendposition")) {
                if (w == null) {
                    sender.sendMessage("Cannot set sendposition on disabled or undefined world");
                    return true;
                }
                w.sendposition = tok[1].equals("true");
                core.updateWorldConfig(w);
                did_update = true;
                continue;
            }
            if (tok[0].equalsIgnoreCase("sendhealth")) {
                if (w == null) {
                    sender.sendMessage("Cannot set sendhealth on disabled or undefined world");
                    return true;
                }
                w.sendhealth = tok[1].equals("true");
                core.updateWorldConfig(w);
                did_update = true;
                continue;
            }
            if (tok[0].equalsIgnoreCase("showborder")) {
                if (w == null) {
                    sender.sendMessage("Cannot set sendworldborder on disabled or undefined world");
                    return true;
                }
                w.showborder = tok[1].equals("true");
                core.updateWorldConfig(w);
                did_update = true;
                continue;
            }
            if (tok[0].equalsIgnoreCase("protected")) {
                if (w == null) {
                    sender.sendMessage("Cannot set protected on disabled or undefined world");
                    return true;
                }
                w.is_protected = tok[1].equals("true");
                core.updateWorldConfig(w);
                did_update = true;
                continue;
            }
            if (tok[0].equalsIgnoreCase("extrazoomout")) {
                if (w == null) {
                    sender.sendMessage("Cannot set extrazoomout on disabled or undefined world");
                    return true;
                }
                int exo = -1;
                try {
                    exo = Integer.valueOf(tok[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (exo < 0 || exo > 32) {
                    sender.sendMessage("Invalid value for extrazoomout: " + tok[1]);
                    return true;
                }
                did_update |= core.setWorldZoomOut(wname, exo);
                continue;
            }
            if (tok[0].equalsIgnoreCase("tileupdatedelay")) {
                if (w == null) {
                    sender.sendMessage("Cannot set tileupdatedelay on disabled or undefined world");
                    return true;
                }
                int tud = -1;
                try {
                    tud = Integer.valueOf(tok[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                did_update |= core.setWorldTileUpdateDelay(wname, tud);
                continue;
            }
            if (tok[0].equalsIgnoreCase("center")) {
                DynmapLocation loc;
                boolean good;
                block38: {
                    if (w == null) {
                        sender.sendMessage("Cannot set center on disabled or undefined world");
                        return true;
                    }
                    good = false;
                    loc = null;
                    try {
                        String[] toks = tok[1].split("/");
                        if (toks.length == 3) {
                            double x = 0.0;
                            double y = 0.0;
                            double z = 0.0;
                            x = Double.valueOf(toks[0]);
                            y = Double.valueOf(toks[1]);
                            z = Double.valueOf(toks[2]);
                            loc = new DynmapLocation(wname, x, y, z);
                            good = true;
                            break block38;
                        }
                        if (tok[1].equalsIgnoreCase("default")) {
                            good = true;
                            break block38;
                        }
                        if (!tok[1].equalsIgnoreCase("here")) break block38;
                        if (sender instanceof DynmapPlayer) {
                            loc = ((DynmapPlayer)sender).getLocation();
                            good = true;
                            break block38;
                        }
                        sender.sendMessage("Setting center to 'here' requires player");
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!good) {
                    sender.sendMessage("Center value must be formatted x/y/z or be set to 'default' or 'here'");
                    return true;
                }
                did_update |= core.setWorldCenter(wname, loc);
                continue;
            }
            if (!tok[0].equalsIgnoreCase("order")) continue;
            if (w == null) {
                sender.sendMessage("Cannot set order on disabled or undefined world");
                return true;
            }
            int order = -1;
            try {
                order = Integer.valueOf(tok[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (order < 1) {
                sender.sendMessage("Order value must be number from 1 to number of worlds");
                return true;
            }
            did_update |= core.setWorldOrder(wname, order - 1);
        }
        if (did_update) {
            sender.sendMessage("Refreshing configuration for world " + wname);
            core.refreshWorld(wname);
        }
        return true;
    }

    private boolean handleMapList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.maplist")) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("World name is required");
            return true;
        }
        String wname = args[1];
        DynmapWorld w = core.getWorld(wname);
        if (w == null) {
            sender.sendMessage("Only loaded world can be listed");
            return true;
        }
        List<MapType> maps = w.maps;
        for (MapType mt : maps) {
            if (!(mt instanceof HDMap)) continue;
            HDMap hdmt = (HDMap)mt;
            StringBuilder sb = new StringBuilder();
            sb.append("map ").append(mt.getName()).append(": prefix=").append(hdmt.getPrefix()).append(", title=").append(hdmt.getTitle());
            sb.append(", perspective=").append(hdmt.getPerspective().getName()).append(", shader=").append(hdmt.getShader().getName());
            sb.append(", lighting=").append(hdmt.getLighting().getName()).append(", mapzoomin=").append(hdmt.getMapZoomIn()).append(", mapzoomout=").append(hdmt.getMapZoomOutLevels());
            sb.append(", img-format=").append(hdmt.getImageFormatSetting()).append(", icon=").append(hdmt.getIcon());
            sb.append(", append-to-world=").append(hdmt.getAppendToWorld()).append(", boostzoom=").append(hdmt.getBoostZoom());
            sb.append(", protected=").append(hdmt.isProtected()).append(", tilescale=").append(hdmt.getTileScale()).append(", readonly=").append(hdmt.isReadOnly());
            if (hdmt.tileupdatedelay > 0) {
                sb.append(", tileupdatedelay=").append(hdmt.tileupdatedelay);
            }
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private boolean handleMapDelete(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.mapdelete")) {
            return true;
        }
        if (this.checkIfActive(core, sender)) {
            return false;
        }
        if (args.length < 2) {
            sender.sendMessage("World:map name required");
            return true;
        }
        for (int i = 1; i < args.length; ++i) {
            String world_map_name = args[i];
            String[] tok = world_map_name.split(":");
            if (tok.length != 2) {
                sender.sendMessage("Invalid world:map name: " + world_map_name);
                return true;
            }
            String wname = tok[0];
            String mname = tok[1];
            DynmapWorld w = core.getWorld(wname);
            if (w == null) {
                sender.sendMessage("Cannot delete maps from disabled or unloaded world: " + wname);
                return true;
            }
            ArrayList<MapType> maps = new ArrayList<MapType>(w.maps);
            boolean done = false;
            for (int idx = 0; !done && idx < maps.size(); ++idx) {
                MapType mt = (MapType)maps.get(idx);
                if (!mt.getName().equals(mname)) continue;
                w.maps.remove(mt);
                done = true;
            }
            if (!done || !core.updateWorldConfig(w)) continue;
            sender.sendMessage("Refreshing configuration for world " + wname);
            core.refreshWorld(wname);
        }
        return true;
    }

    private boolean handleWorldReset(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.worldreset")) {
            return true;
        }
        if (this.checkIfActive(core, sender)) {
            return false;
        }
        if (args.length < 2) {
            sender.sendMessage("World name required");
            return true;
        }
        String wname = args[1];
        DynmapWorld w = core.getWorld(wname);
        if (w == null) {
            sender.sendMessage("Cannot reset world that is not loaded or enabled");
            return true;
        }
        ConfigurationNode cn = null;
        cn = args.length > 2 ? core.getTemplateConfigurationNode(args[2]) : core.getDefaultTemplateConfigurationNode(w);
        if (cn == null) {
            sender.sendMessage("Cannot load template");
            return true;
        }
        ConfigurationNode cfg = w.saveConfiguration();
        cfg.extend(cn);
        if (core.replaceWorldConfig(wname, cfg)) {
            sender.sendMessage("Reset configuration for world " + wname);
            core.refreshWorld(wname);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleMapSet(DynmapCommandSender sender, String[] args, DynmapCore core, boolean isnew) {
        if (!core.checkPlayerPermission(sender, isnew ? "dmap.mapadd" : "dmap.mapset")) {
            return true;
        }
        if (this.checkIfActive(core, sender)) {
            return false;
        }
        if (args.length < 2) {
            sender.sendMessage("World:map name required");
            return true;
        }
        String world_map_name = args[1];
        String[] stringArray = world_map_name.split(":");
        if (stringArray.length != 2) {
            sender.sendMessage("Invalid world:map name: " + world_map_name);
            return true;
        }
        String wname = stringArray[0];
        String mname = stringArray[1];
        DynmapWorld w = core.getWorld(wname);
        if (w == null) {
            sender.sendMessage("Cannot update maps from disabled or unloaded world: " + wname);
            return true;
        }
        HDMap mt = null;
        for (MapType map : w.maps) {
            if (!(map instanceof HDMap) || !map.getName().equals(mname)) continue;
            mt = (HDMap)map;
            break;
        }
        if (isnew) {
            if (mt != null) {
                sender.sendMessage("Map " + mname + " already exists on world " + wname);
                return true;
            }
            ConfigurationNode cn = new ConfigurationNode();
            cn.put("name", (Object)mname);
            mt = new HDMap(core, cn);
            if (mt.getName() == null) {
                sender.sendMessage("Map " + mname + " not valid");
                return true;
            }
            w.maps.add(mt);
        } else if (mt == null) {
            sender.sendMessage("Map " + mname + " not found on world " + wname);
            return true;
        }
        boolean did_update = isnew;
        int i = 2;
        while (true) {
            block48: {
                void var6_10;
                Object newtok;
                block46: {
                    block44: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block47: {
                                                                            block45: {
                                                                                if (i >= args.length) break block44;
                                                                                String[] stringArray2 = args[i].split(":", 2);
                                                                                if (stringArray2.length < 2) {
                                                                                    newtok = new String[]{stringArray2[0], ""};
                                                                                    Object object = newtok;
                                                                                }
                                                                                if (!var6_10[0].equalsIgnoreCase("prefix")) break block45;
                                                                                newtok = w.maps.iterator();
                                                                                break block46;
                                                                            }
                                                                            if (!var6_10[0].equalsIgnoreCase("title")) break block47;
                                                                            did_update |= mt.setTitle((String)var6_10[1]);
                                                                            break block48;
                                                                        }
                                                                        if (!var6_10[0].equalsIgnoreCase("icon")) break block49;
                                                                        did_update |= mt.setIcon((String)var6_10[1]);
                                                                        break block48;
                                                                    }
                                                                    if (!var6_10[0].equalsIgnoreCase("mapzoomin")) break block50;
                                                                    int mzi = -1;
                                                                    try {
                                                                        mzi = Integer.valueOf((String)var6_10[1]);
                                                                    }
                                                                    catch (NumberFormatException numberFormatException) {
                                                                        // empty catch block
                                                                    }
                                                                    if (mzi < 0 || mzi > 32) {
                                                                        sender.sendMessage("Invalid mapzoomin value: " + (String)var6_10[1]);
                                                                        return true;
                                                                    }
                                                                    did_update |= mt.setMapZoomIn(mzi);
                                                                    break block48;
                                                                }
                                                                if (!var6_10[0].equalsIgnoreCase("mapzoomout")) break block51;
                                                                int mzi = -1;
                                                                try {
                                                                    mzi = Integer.valueOf((String)var6_10[1]);
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    // empty catch block
                                                                }
                                                                if (mzi < 0 || mzi > 32) {
                                                                    sender.sendMessage("Invalid mapzoomout value: " + (String)var6_10[1]);
                                                                    return true;
                                                                }
                                                                did_update |= mt.setMapZoomOut(mzi);
                                                                break block48;
                                                            }
                                                            if (!var6_10[0].equalsIgnoreCase("boostzoom")) break block52;
                                                            int mzi = -1;
                                                            try {
                                                                mzi = Integer.valueOf((String)var6_10[1]);
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                // empty catch block
                                                            }
                                                            if (mzi < 0 || mzi > 3) {
                                                                sender.sendMessage("Invalid boostzoom value: " + (String)var6_10[1]);
                                                                return true;
                                                            }
                                                            did_update |= mt.setBoostZoom(mzi);
                                                            break block48;
                                                        }
                                                        if (!var6_10[0].equalsIgnoreCase("tilescale")) break block53;
                                                        int mzi = -1;
                                                        try {
                                                            mzi = Integer.valueOf((String)var6_10[1]);
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            // empty catch block
                                                        }
                                                        if (mzi < 0 || mzi > 4) {
                                                            sender.sendMessage("Invalid tilescale value: " + (String)var6_10[1]);
                                                            return true;
                                                        }
                                                        did_update |= mt.setTileScale(mzi);
                                                        break block48;
                                                    }
                                                    if (!var6_10[0].equalsIgnoreCase("tileupdatedelay")) break block54;
                                                    int tud = -1;
                                                    try {
                                                        tud = Integer.valueOf((String)var6_10[1]);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        // empty catch block
                                                    }
                                                    did_update |= mt.setTileUpdateDelay(tud);
                                                    break block48;
                                                }
                                                if (!var6_10[0].equalsIgnoreCase("perspective")) break block55;
                                                if (MapManager.mapman != null) {
                                                    HDPerspective p = MapManager.mapman.hdmapman.perspectives.get(var6_10[1]);
                                                    if (p == null) {
                                                        sender.sendMessage("Perspective not found: " + (String)var6_10[1]);
                                                        return true;
                                                    }
                                                    did_update |= mt.setPerspective(p);
                                                }
                                                break block48;
                                            }
                                            if (!var6_10[0].equalsIgnoreCase("shader")) break block56;
                                            if (MapManager.mapman != null) {
                                                HDShader s = MapManager.mapman.hdmapman.shaders.get(var6_10[1]);
                                                if (s == null) {
                                                    sender.sendMessage("Shader not found: " + (String)var6_10[1]);
                                                    return true;
                                                }
                                                did_update |= mt.setShader(s);
                                            }
                                            break block48;
                                        }
                                        if (!var6_10[0].equalsIgnoreCase("lighting")) break block57;
                                        if (MapManager.mapman != null) {
                                            HDLighting l = MapManager.mapman.hdmapman.lightings.get(var6_10[1]);
                                            if (l == null) {
                                                sender.sendMessage("Lighting not found: " + (String)var6_10[1]);
                                                return true;
                                            }
                                            did_update |= mt.setLighting(l);
                                        }
                                        break block48;
                                    }
                                    if (!var6_10[0].equalsIgnoreCase("img-format")) break block58;
                                    if (!var6_10[1].equals("default") && MapType.ImageFormat.fromID((String)var6_10[1]) == null) {
                                        sender.sendMessage("Image format not found: " + (String)var6_10[1]);
                                        return true;
                                    }
                                    did_update |= mt.setImageFormatSetting((String)var6_10[1]);
                                    break block48;
                                }
                                if (!var6_10[0].equalsIgnoreCase("order")) break block59;
                                int idx = -1;
                                try {
                                    idx = Integer.valueOf((String)var6_10[1]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (idx < 1) {
                                    sender.sendMessage("Invalid order position: " + (String)var6_10[1]);
                                    return true;
                                }
                                w.maps.remove(mt);
                                if (--idx < w.maps.size()) {
                                    w.maps.add(idx, mt);
                                } else {
                                    w.maps.add(mt);
                                }
                                did_update = true;
                                break block48;
                            }
                            if (!var6_10[0].equalsIgnoreCase("append-to-world")) break block60;
                            did_update |= mt.setAppendToWorld((String)var6_10[1]);
                            break block48;
                        }
                        if (var6_10[0].equalsIgnoreCase("protected")) {
                            did_update |= mt.setProtected(Boolean.parseBoolean((String)var6_10[1]));
                            break block48;
                        } else if (var6_10[0].equalsIgnoreCase("readonly")) {
                            did_update |= mt.setReadOnly(Boolean.parseBoolean((String)var6_10[1]));
                        }
                        break block48;
                    }
                    if (did_update && core.updateWorldConfig(w)) {
                        sender.sendMessage("Refreshing configuration for world " + wname);
                        core.refreshWorld(wname);
                    }
                    return true;
                }
                while (newtok.hasNext()) {
                    MapType map = (MapType)newtok.next();
                    if (map == mt || !(map instanceof HDMap) || !((HDMap)map).getPrefix().equals(var6_10[1])) continue;
                    sender.sendMessage("Prefix " + (String)var6_10[1] + " already in use");
                    return true;
                }
                did_update |= mt.setPrefix((String)var6_10[1]);
            }
            ++i;
        }
    }

    private boolean handlePerspectiveList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.perspectivelist")) {
            return true;
        }
        if (MapManager.mapman != null) {
            StringBuilder sb = new StringBuilder();
            for (HDPerspective p : MapManager.mapman.hdmapman.perspectives.values()) {
                sb.append(p.getName()).append(' ');
            }
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private boolean handleShaderList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.shaderlist")) {
            return true;
        }
        if (MapManager.mapman != null) {
            StringBuilder sb = new StringBuilder();
            for (HDShader p : MapManager.mapman.hdmapman.shaders.values()) {
                sb.append(p.getName()).append(' ');
            }
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private boolean handleLightingList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.lightinglist")) {
            return true;
        }
        if (MapManager.mapman != null) {
            StringBuilder sb = new StringBuilder();
            for (HDLighting p : MapManager.mapman.hdmapman.lightings.values()) {
                sb.append(p.getName()).append(' ');
            }
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private boolean handleBlockList(DynmapCommandSender sender, String[] args, DynmapCore core) {
        if (!core.checkPlayerPermission(sender, "dmap.blklist")) {
            return true;
        }
        Map<String, Integer> map = core.getServer().getBlockUniqueIDMap();
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        for (String k : keys) {
            sender.sendMessage(k + ": " + map.get(k));
        }
        return true;
    }
}

