function makePageLosing(){   
        // Body classes
        document.body.classList.add(
            "relative", "bg-gray-200", "h-screen", "text-white",
            "flex", "flex-col", "justify-between", "items-center"
        );
        document.title = "Game Over";
    
        // Background Image
        const backgroundImage = document.createElement("img");
        backgroundImage.src = "/Frontend/src/assets/images/background.png";
        backgroundImage.alt = "Temple Background Image";
        backgroundImage.classList.add("object-cover", "z-0", "fixed", "w-full", "h-full");
        document.body.appendChild(backgroundImage);
    
        // Didn't win message
        const messageContainer = document.createElement("div");
        messageContainer.classList.add("flex", "flex-col", "items-center", "lg:mt-2", "mb-8", "z-10");
    
        const message = document.createElement("h1");
        message.classList.add("text-xl", "lg:text-6xl", "text-center", "mb-4", "bg-black", "bg-opacity-75", "p-3");
        message.textContent = "Didn't win this time, but every loss brings you closer to victory!";
        messageContainer.appendChild(message);
        document.body.appendChild(messageContainer);
    
        // Losing Photo
        const losingPhoto = document.createElement("div");
        losingPhoto.classList.add("w-56", "h-56", "bg-cover", "bg-center", "animate-bounce");
        losingPhoto.style.backgroundImage = "url('/Frontend/src/assets/images/losingPhoto.png')";
        document.body.appendChild(losingPhoto);
    
        // Return to Lobby Link
        const returnToLobbyContainer = document.createElement("div");
        returnToLobbyContainer.classList.add("flex", "flex-col", "items-center", "text-center", "z-10");
    
        const returnToLobby = document.createElement("a");
        returnToLobby.href = "/Frontend/src/auth/lobby.html";
        returnToLobby.classList.add("bg-black", "bg-opacity-95", "p-4", "lg:p-5", "text-xl", "lg:text-2xl", "font-bold", "hover:text-yellow-500", "focus:text-yellow-500", "transition-all", "duration-300", "lg:mb-2");
        returnToLobby.id = "returnToLobby";
        returnToLobby.textContent = "Return to lobby";
        returnToLobbyContainer.appendChild(returnToLobby);
        document.body.appendChild(returnToLobbyContainer);
}
export{
    makePageLosing
}
