﻿using Onitama.Core.GameAggregate.Contracts;
using Onitama.Core.PlayerAggregate.Contracts;
using Onitama.Core.TableAggregate.Contracts;
using Onitama.Core.UserAggregate;

namespace Onitama.Core.TableAggregate;

/// <inheritdoc cref="ITableManager"/>
internal class TableManager : ITableManager
{
    ITableRepository _tableRepository;
    ITableFactory _tableFactory;
    IGameRepository _gameRepository;
    IGameFactory _gameFactory;
    IGamePlayStrategy _gamePlayStrategy;
    public TableManager(
        ITableRepository tableRepository, 
        ITableFactory tableFactory, 
        IGameRepository gameRepository,
        IGameFactory gameFactory,
        IGamePlayStrategy gamePlayStrategy)
    {
        this._tableRepository = tableRepository;
        this._tableFactory = tableFactory;
        this._gameRepository = gameRepository;
        this._gameFactory = gameFactory;
        this._gamePlayStrategy = gamePlayStrategy;
    }

    public ITable AddNewTableForUser(User user, TablePreferences preferences)
    {
        ITable table = _tableFactory.CreateNewForUser(user, preferences);
        _tableRepository.Add(table);
        return table;
        
    }

    public void JoinTable(Guid tableId, User user)
    {
        ITable table = _tableRepository.Get(tableId);
        table.Join(user);
    }

    public void LeaveTable(Guid tableId, User user)
    {
        ITable table = _tableRepository.Get(tableId);
        table.Leave(user.Id);
        if (table.SeatedPlayers.Count == 0)
        {
            _tableRepository.Remove(table.Id);
        }
    }

    public void FillWithArtificialPlayers(Guid tableId, User user)
    {
        throw new NotImplementedException();
    }

    public IGame StartGameForTable(Guid tableId, User user)
    {
        ITable table = _tableRepository.Get(tableId);
        if (table.HasAvailableSeat)
        {
            throw new InvalidOperationException("Not enough players to start the game");
        }

        if (table.OwnerPlayerId != user.Id)
        {
            throw new InvalidOperationException("User is not the owner");
        }
        IGame game = _gameFactory.CreateNewForTable(table);
        table.GameId = game.Id;
        _gameRepository.Add(game);
        return game;
    }
}