﻿using System.Drawing;
using Onitama.Core.MoveCardAggregate.Contracts;
using Onitama.Core.PlayerAggregate.Contracts;
using Onitama.Core.SchoolAggregate;
using Onitama.Core.SchoolAggregate.Contracts;
using Onitama.Core.Util;

namespace Onitama.Core.PlayerAggregate;

/// <inheritdoc cref="IPlayer"/>
internal class PlayerBase : IPlayer
{
    private Guid _id;
    private string _name;
    private Color _color;
    private Direction _direction;
    private ISchool _school;
    private IList<IMoveCard> _moveCards = new List<IMoveCard>();
   
    protected PlayerBase(Guid userId, string name, Color color, Direction direction)
    {
        _id = userId;
        _name = name;
        _color = color;
        _direction = direction;
        _school = new School(userId, direction.GetStartCoordinate());
    }

    /// <summary>
    /// Creates a player that is a copy of an other player.
    /// </summary>
    /// <remarks>
    /// This is an EXTRA. Not needed to implement the minimal requirements.
    /// To make the mini-max algorithm for an AI game play strategy work, this constructor should be implemented.
    /// </remarks>
    public PlayerBase(IPlayer otherPlayer)
    {
        throw new NotImplementedException("TODO: copy properties of other player");
    }
    public Guid Id { get { return _id; } }
    public string Name { get { return _name; } }
    public Color Color { get { return _color; } }
    public Direction Direction { get { return _direction; } }
    public ISchool School { get { return _school; } }
    public IList<IMoveCard> MoveCards { get { return _moveCards; } }
}