﻿using System.Drawing;
using Onitama.Core.MoveCardAggregate.Contracts;
using Onitama.Core.Util;
using Onitama.Core.Util.Contracts;

namespace Onitama.Core.MoveCardAggregate;

/// <inheritdoc cref="IMoveCard"/>
internal class MoveCard : IMoveCard
{
    public string Name { get; }
    public MoveCardGridCellType[,] Grid { get; }
    public Color StampColor { get; }

    public IReadOnlyList<ICoordinate> GetPossibleTargetCoordinates(ICoordinate startCoordinate, Direction playDirection,
        int matSize)
    {
        List<ICoordinate> coordinates = new List<ICoordinate>();
        MoveCardGridCellType[,] newGrid = new MoveCardGridCellType[5,5];
        // Rotate the grid and starting coördinate if needed
        if (playDirection == Direction.South)
        {
            // Loop through the grid and rotate the grid
            for (int row = 0; row < matSize; row++)
            {
                for (int column = 0; column < matSize; column++)
                {
                    newGrid[4 - row, 4 - column] = Grid[row, column];
                }
            }
        }
        else
        {
            newGrid = Grid;
        }

        for (int row = 0; row < matSize; row++)
        {
            for (int column = 0; column < matSize; column++)
            {
                if (newGrid[row, column] == MoveCardGridCellType.Target)
                {
                    int targetRow = row + startCoordinate.Row - 2;
                    int targetColumn = column + startCoordinate.Column - 2;

                    ICoordinate possibleTarget = new Coordinate(targetRow, targetColumn);
                    // Check if target is in bounds
                    if (!possibleTarget.IsOutOfBounds(matSize))
                    {
                        coordinates.Add(possibleTarget);
                    }
                }
            }
        }

        return coordinates;
    }

    public MoveCard(string name, MoveCardGridCellType[,] grid, Color stampColor)
    {
        Name = name;
        Grid = grid;
        StampColor = stampColor;
    }

    //Do not change this method, it makes sure that two MoveCard instances are equal if their names are equal
    public override bool Equals(object obj)
    {
        if (obj is null) return false;
        return obj is IMoveCard other && Equals(other);
    }

    //Do not change this method
    protected bool Equals(IMoveCard other)
    {
        return Name == other.Name;
    }

    //Do not change this method
    public override int GetHashCode()
    {
        return (Name != null ? Name.GetHashCode() : 0);
    }
}