﻿using Onitama.Core.GameAggregate.Contracts;
using Onitama.Core.MoveCardAggregate.Contracts;
using Onitama.Core.SchoolAggregate.Contracts;
using Onitama.Core.Util;
using Onitama.Core.Util.Contracts;

namespace Onitama.Core.GameAggregate;

internal class Move : IMove
{
    private IMoveCard _card;
    private IPawn _pawn;
    private Direction _playerDirection;
    private ICoordinate _to;
    public IMoveCard Card => _card;

    public IPawn Pawn => _pawn;

    public Direction PlayerDirection => _playerDirection;

    public ICoordinate To => _to;

    public Move(IMoveCard card)
    {
        _card = card;
    }

    public Move(IMoveCard card, IPawn pawn, Direction playerDirection, ICoordinate to)
    {
        _card = card;
        _pawn = pawn;
        _playerDirection = playerDirection;
        _to = to;
    }

    public override bool Equals(object obj)
    {
        if (ReferenceEquals(null, obj)) return false;
        if (ReferenceEquals(this, obj)) return true;
        if (obj.GetType() != this.GetType()) return false;
        return Equals((Move)obj);
    }

    protected bool Equals(Move other)
    {
        return Equals(_card, other._card) && Equals(_pawn, other._pawn) && Equals(_playerDirection, other._playerDirection) && Equals(_to, other._to);
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(_card, _pawn, _playerDirection, _to);
    }
}