import {
  createNotification,
  initializeNotifications,
  parameterNotifications,
} from "../../assets/js/customNotification.js";
import {
  hasEmptyFields,
  redirectToLoginWithoutBearer,
} from "../../assets/js/customAuthFlow.js";
import { createTable } from "../../assets/js/customTable.js";

window.addEventListener("load", load);

function load() {
  // Notifications
  initializeNotifications();
  parameterNotifications();

  redirectToLoginWithoutBearer();

  // URLSearchParams
  let urlSearchParams = new URLSearchParams(location.search);
  let numberOfPlayers = urlSearchParams.get("numberOfPlayers");
  let playmatSize = urlSearchParams.get("playmatSize");
  let movecardSet = urlSearchParams.get("movecardSet");

  if (numberOfPlayers || playmatSize || movecardSet) {
    if (hasEmptyFields(numberOfPlayers, playmatSize, movecardSet)) {
      createNotification("Invalid fields");
    } else {
        createTable(numberOfPlayers, playmatSize, movecardSet);
    }
  }

  let numberOfPlayers2 = document.getElementById("numberOfPlayers2");
  let numberOfPlayers4 = document.getElementById("numberOfPlayers4");

  if (numberOfPlayers == 4) {
    selectPlayers(numberOfPlayers4);
  } else {
    selectPlayers(numberOfPlayers2);
  }

  numberOfPlayers2.addEventListener("click", () =>
    selectPlayers(numberOfPlayers2)
  );
  numberOfPlayers4.addEventListener("click", () =>
    selectPlayers(numberOfPlayers4)
  );

  let originalCardSet = document.getElementById("originalCardSet");
  let senseiCardSet = document.getElementById("senseiCardSet");

  if (movecardSet == 1) {
    selectCards(senseiCardSet);
  } else {
    selectCards(originalCardSet);
  }

  originalCardSet.addEventListener("click", () =>
    selectCards(originalCardSet)
  );
  senseiCardSet.addEventListener("click", () =>
    selectCards(senseiCardSet)
  );
}

function selectPlayers(selectedNumber) {
  clearNumberOfPlayersSelection();
  selectedNumber.classList.add("border-yellow-500", "text-yellow-500");
}

function clearNumberOfPlayersSelection() {
  let numberOfPlayers2 = document.getElementById("numberOfPlayers2");
  let numberOfPlayers4 = document.getElementById("numberOfPlayers4");

  numberOfPlayers2.classList.remove("border-yellow-500", "text-yellow-500");
  numberOfPlayers4.classList.remove("border-yellow-500", "text-yellow-500");
}

function selectCards(selectedCards) {
  clearCardsSelection();
  selectedCards.classList.add("border-yellow-500", "text-yellow-500");
}

function clearCardsSelection() {
  let originalCardSet = document.getElementById("originalCardSet");
  let senseiCardSet = document.getElementById("senseiCardSet");

  originalCardSet.classList.remove("border-yellow-500", "text-yellow-500");
  senseiCardSet.classList.remove("border-yellow-500", "text-yellow-500");
}
