function showDefeatedPawn() {
    addAnimationStyles();

    const defeatedPawnOverlay = createElement('div', {
        id: 'defeatedPawnOverlay',
        class: 'fixed top-0 left-0 w-full h-full bg-black bg-opacity-75 flex justify-center items-center hidden',
        style: 'z-index: 9999;', 
    }, [

        createElement('div', { class: 'text-white text-center' }, [

            createElement('img', {
                src: '/Frontend/src/assets/images/pawn.png',
                class: 'w-16 h-16 animate-growAndFall'
            }),

            createElement('p', { class: 'mt-20 font-bold text-xl' }, ['Defeated']),
        ]),
    ]);

    document.body.appendChild(defeatedPawnOverlay);
    defeatedPawnOverlay.classList.remove('hidden');

    setTimeout(() => {
        defeatedPawnOverlay.classList.add('hidden');
        defeatedPawnOverlay.remove();
        document.querySelector('style').remove();
    }, 1500);
}

function createElement(tagName, attributes = {}, children = []) {
    const element = document.createElement(tagName);
    for (const key in attributes) {
        element.setAttribute(key, attributes[key]);
    }
    children.forEach(child => {
        if (typeof child === 'string') {
            element.appendChild(document.createTextNode(child));
        } else {
            element.appendChild(child);
        }
    });
    return element;
}


function addAnimationStyles() {
    const style = createElement('style', {}, [
        document.createTextNode(`
        @keyframes growAndFall {
          0% {
            transform: scale(3);
          }
          50% {
            transform: scale(3.5);
          }
          100% {
            transform: scale(3) rotate(90deg);
          }
        }
        .animate-growAndFall {
          animation: growAndFall 1s ease forwards;
        }
      `),
    ]);
    document.head.appendChild(style);
}

export{
    showDefeatedPawn
}