﻿using Onitama.Core.Util.Contracts;

namespace Onitama.Core.Util;

/// <inheritdoc cref="ICoordinate"/>
internal class Coordinate : ICoordinate
{
    public int Row { get; }
    public int Column { get; }

    public bool IsOutOfBounds(int playMatSize)
    {
        return !(Row >= 0
               && Row < playMatSize
               && Column >= 0
               && Column < playMatSize);
    }

    public ICoordinate GetNeighbor(Direction direction)
    {
        throw new NotImplementedException();
    }

    public ICoordinate RotateTowards(Direction direction)
    {
        if (direction == Direction.East)
        {
            return new Coordinate(-Column, Row);
        }

        if (direction == Direction.South)
        {
            return new Coordinate(-Row, -Column);
        }

        if (direction == Direction.West)
        {
            return new Coordinate(Column, -Row);
        }

        // If no direction is correct, it will always be north
        return new Coordinate(Row, Column);
    }

    public int GetDistanceTo(ICoordinate other)
    {
        int xDistance = Math.Abs(Row - other.Row);
        int yDistance = Math.Abs(Column - other.Column);
        int distance = (int)(Math.Sqrt(Math.Pow(xDistance, 2) + Math.Pow(yDistance, 2)));

        return distance;
    }

    public Coordinate(int row, int column)
    {
        Row = row;
        Column = column;
    }

    //Do not change this method
    public override bool Equals(object obj)
    {
        if (obj is null) return false;
        return obj is ICoordinate other && Equals(other);
    }

    //Do not change this method
    protected bool Equals(ICoordinate other)
    {
        return Row == other.Row && Column == other.Column;
    }

    //Do not change this method
    public override int GetHashCode()
    {
        return HashCode.Combine(Row, Column);
    }

    //Do not change this method
    public override string ToString()
    {
        return $"({Row}, {Column})";
    }
}