﻿using Onitama.Core.SchoolAggregate.Contracts;
using Onitama.Core.Util;
using Onitama.Core.Util.Contracts;

namespace Onitama.Core.SchoolAggregate;

/// <inheritdoc cref="ISchool"/>
internal class School : ISchool
{
    /// <summary>
    /// Creates a school that is a copy of another school.
    /// </summary>
    /// <remarks>
    /// This is an EXTRA. Not needed to implement the minimal requirements.
    /// To make the mini-max algorithm for an AI game play strategy work, this constructor should be implemented.
    /// </remarks>
    ///
    public School(ISchool otherSchool)
    {
        throw new NotImplementedException("TODO: copy properties of other school. Make sure to copy the pawns, not just reference them");
    }

    private IPawn _master;
    private IPawn[] _allPawns = new IPawn[5];
    private IPawn[] _students = new IPawn[4];

    public School(Guid playerId, ICoordinate startPosition)
    {
        for (int i = 0; i < 5; i++)
        {
            IPawn newPawn;
            // Master pawn 
            // ALWAYS IN THE MIDDLE !! 
            if (i == 2)
            {
                newPawn = new Pawn(Guid.NewGuid(), playerId, PawnType.Master);
                _master = newPawn;
            }
            else
            {
                newPawn = new Pawn(Guid.NewGuid(), playerId, PawnType.Student);
                _students[i >= 2 ? i - 1 : i] = newPawn;
            }

            newPawn.Position = new Coordinate(startPosition.Row, i);

            _allPawns[i] = newPawn;
        }

        TempleArchPosition = startPosition;
    }

    public IPawn Master => _master;
    public IPawn[] Students => _students;
    public IPawn[] AllPawns => _allPawns;
    public ICoordinate TempleArchPosition { get; set; }
    public IPawn GetPawn(Guid pawnId)
    {
        foreach(IPawn pawn in AllPawns)
        {
            if (pawn.Id == pawnId)
            {
                return pawn;
            }
        }

        throw new InvalidOperationException("Pawn does not exist");
    }
}