﻿using Onitama.Core.SchoolAggregate.Contracts;
using Onitama.Core.Util.Contracts;

namespace Onitama.Core.SchoolAggregate;

/// <inheritdoc cref="IPawn"/>
internal class Pawn : IPawn
{
    private Guid _id;
    private Guid _ownerId;
    private PawnType _type;
    private ICoordinate _position;
    public Guid Id => _id;
    public Guid OwnerId => _ownerId;
    public PawnType Type => _type;
    public ICoordinate Position
    {
        get
        {
            return _position;
        }
        set
        {
            _position = value;
        }
    }

    public Pawn(Guid id, Guid ownerId, PawnType type)
    {
        _id = id;
        _ownerId = ownerId;
        _type = type;
        
    }
}