import {
  createNotification,
  initializeNotifications,
  parameterNotifications,
} from "./assets/js/customNotification.js";
import {
  login,
  register,
  hasEmptyFields,
  refillRegisterForm,
  toggleLoginForm,
  toggleRegisterForm
} from "./assets/js/customAuthFlow.js";

window.addEventListener("load", load);

function load() {
  // Notifications
  initializeNotifications();
  parameterNotifications();

  toggleLoginForm();

  // URLSearchParams
  let urlSearchParams = new URLSearchParams(location.search);
  let loginEmail = urlSearchParams.get("loginEmail");
  let loginPassword = urlSearchParams.get("loginPassword");
  let registerEmail = urlSearchParams.get("registerEmail");
  let registerUsername = urlSearchParams.get("registerUsername");
  let registerPassword = urlSearchParams.get("registerPassword");
  let registerPasswordConfirmation = urlSearchParams.get(
    "registerPasswordConfirmation"
  );

  

  // Login
  if (loginEmail || loginPassword) {
    if (hasEmptyFields(loginEmail, loginPassword)) {
      createNotification("Invalid username or password");
    } else {
      login(loginEmail, loginPassword);
    }
  }

  // Register
  else if (
    registerEmail ||
    registerUsername ||
    registerPassword ||
    registerPasswordConfirmation
  ) {
    toggleRegisterForm();
    if (
      hasEmptyFields(
        registerEmail,
        registerUsername,
        registerPassword,
        registerPasswordConfirmation
      )
    ) {
      refillRegisterForm(
        registerEmail,
        registerUsername,
        registerPassword,
        registerPasswordConfirmation
      );
      createNotification("Invalid fields");
    } else if (registerPassword !== registerPasswordConfirmation) {
      refillRegisterForm(registerEmail, registerUsername);
      createNotification("Passwords not equal");
    } else if (
      registerPassword.length < 6 ||
      registerPasswordConfirmation.length < 6
    ) {
      refillRegisterForm(registerEmail, registerUsername);
      createNotification("Passwords needs 6 characters");
    } else {
      register(registerEmail, registerUsername, registerPassword);
    }
  }

  let signInButton = document.getElementById("signInButton");
  let registerButton = document.getElementById("registerButton");
  let creatorsButton = document.getElementById("creatorsButton");

  signInButton.addEventListener("click", toggleLoginForm);
  registerButton.addEventListener("click", toggleRegisterForm);
  creatorsButton.addEventListener("click", goToCreators);
}

function goToCreators() {
  window.scrollTo(0, window.innerHeight);
}
