import {
  initializeNotifications,
  parameterNotifications,
} from "../../assets/js/customNotification.js";
import { redirectToLoginWithoutBearer } from "../../assets/js/customAuthFlow.js";
import {
  displayBoard,
  displayGame,
  gameNotFound,
  getDirectionForPlayerGame,
  skipMovement,
} from "../../assets/js/customGame.js";

window.addEventListener("load", load);

async function load() {
  // Notifications
  initializeNotifications();
  parameterNotifications();

  redirectToLoginWithoutBearer();
  // URLSearchParams
  let urlSearchParams = new URLSearchParams(location.search);
  let gameId = urlSearchParams.get("gameId");

  if (!gameId || gameId.length == 0) {
    gameNotFound("empty");
  } else {
    let direction = await getDirectionForPlayerGame(gameId);
    displayBoard(direction);
    await displayGame(gameId);
  }

  let skipMovementButton = document.getElementById("skipMovementButton");
  if (skipMovementButton) {
    skipMovementButton.addEventListener("click", skipMovement);
  }
}
