function makePageWinning(winnerMethod){
    document.body.classList.add(
        "relative", "bg-gray-200", "h-screen", "flex", 
        "flex-col", "justify-between", "items-center", "text-white"
    );
    document.title = "Win";

     // Background Image
     const backgroundImage = document.createElement("img");
     backgroundImage.src = "/Frontend/src/assets/images/background.png";
     backgroundImage.alt = "Temple Background Image";
     backgroundImage.classList.add("object-cover", "z-0", "fixed", "w-full", "h-full");
     document.body.appendChild(backgroundImage);
 
     // Confetti Container
     const confettiContainer = document.createElement("div");
     confettiContainer.id = "confettiContainer";
     confettiContainer.classList.add("fixed", "top-0", "bottom-0", "left-0", "right-0");
     document.body.appendChild(confettiContainer);
 
     // Congratulations Message
     const congratsMessageContainer = document.createElement("div");
     congratsMessageContainer.classList.add("flex", "flex-col", "items-center", "mb-8", "z-10", "bg-black", "bg-opacity-75", "p-3", "lg:mt-2");
 
     const congratsMessage = document.createElement("h1");
     congratsMessage.classList.add("font-serif", "text-xl", "lg:text-6xl", "text-center", "mt-4", "mb-4");
     congratsMessage.textContent = "Congratulations on your victory in Onitama!";

     const winnerMethodMessage = document.createElement("h1");
     winnerMethodMessage.classList.add("font-serif", "text-xl", "lg:text-5xl", "text-center", "mt-4", "mb-4");
     winnerMethodMessage.textContent = "You won with the " + winnerMethod + " strategy";
     congratsMessageContainer.appendChild(congratsMessage);
     congratsMessageContainer.appendChild(winnerMethodMessage);
     document.body.appendChild(congratsMessageContainer);
 
     // Trophy Image
     const trophyImageContainer = document.createElement("div");
     trophyImageContainer.classList.add("flex", "flex-col", "items-center", "z-10");
 
     const trophyImage = document.createElement("img");
     trophyImage.id = "trophyImage";
     trophyImage.src = "/Frontend/src/assets/images/trophy.png";
     trophyImage.alt = "trophy";
     trophyImage.classList.add("w-64", "h-auto", "mb-4");
     trophyImageContainer.appendChild(trophyImage);
     document.body.appendChild(trophyImageContainer);
 
     // Return to Lobby Link
     const returnToLobbyContainer = document.createElement("div");
     returnToLobbyContainer.classList.add("flex", "flex-col", "items-center", "text-center", "z-10");
 
     const returnToLobby = document.createElement("a");
     returnToLobby.href = "/Frontend/src/auth/lobby.html";
     returnToLobby.classList.add("bg-black", "bg-opacity-95", "p-4", "lg:p-5", "text-xl", "lg:text-2xl", "font-bold", "hover:text-yellow-500", "focus:text-yellow-500", "transition-all", "duration-300", "lg:mb-2");
     
     returnToLobby.id = "returnToLobby";
     returnToLobby.textContent = "Return to lobby";
     returnToLobbyContainer.appendChild(returnToLobby);
     document.body.appendChild(returnToLobbyContainer);
 
     // Add styles for the trophy image animation
     const style = document.createElement("style");
     style.textContent = `
         img#trophyImage {
             transform: translateY(-50%) rotate(-10deg);
             animation: trophyImage 2s ease-in-out infinite alternate;
         }
         @keyframes trophyImage {
             0% {
                 transform: translateY(-50%) rotate(-10deg);
             }
             100% {
                 transform: translateY(-50%) rotate(10deg);
             }
         }
     `;
     document.head.appendChild(style);
    setInterval(addConfetti, 80)
    const lobby = getElementById('returnToLobby')
    lobby.addEventListener('click', lobby)
}

function addConfetti() {
    const confettiContainer = document.getElementById('confettiContainer');
    const colors = ['#ff0000', '#ff7f00', '#ffff00', '#00ff00', '#0000ff', '#4b0082', '#9400d3', '#ff1493', '#ff4500', '#ffd700', '#00ff7f', '#00ffff'];
    const confetti = document.createElement('div');
    confetti.classList.add('w-2', 'h-2', 'rounded-full', 'bg-red-500', 'absolute');
    confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
    confettiContainer.appendChild(confetti);
    animateConfetti(confetti);
}

function animateConfetti(confetti) {
    const duration = Math.random() * 3000 + 1000;
    const randomX = Math.random() * window.innerWidth;
    const randomRotation = Math.random() * 360;
    const screenHeight = window.innerHeight;
    const targetHeight = Math.random() * (screenHeight / 2);

    confetti.animate([
        { transform: `translate(${randomX}px, ${screenHeight}px) rotate(0deg)` },
        { transform: `translate(${randomX}px, ${targetHeight}px) rotate(${randomRotation}deg)` }
    ], {
        duration: duration,
        easing: 'cubic-bezier(0.4, 0, 0.2, 1)',
        fill: 'forwards'
    });


    setTimeout(() => {
        confetti.animate([
            { transform: `translate(${randomX}px, ${targetHeight}px) rotate(${randomRotation}deg)` },
            { transform: `translate(${randomX}px, ${screenHeight}px) rotate(${randomRotation}deg)` }
        ], {
            duration: duration * 0.5,
            easing: 'ease-in-out',
            fill: 'forwards'
        }).onfinish = () => {
            confetti.remove();
        };
    }, duration);


    confetti.addEventListener('animationend', () => {
        confetti.remove();
    });
}

export{
    makePageWinning
}