function initializeNotifications() {
  let body = document.body;
  let div = document.createElement("div");
  div.classList.add(
    "z-50",
    "flex",
    "flex-col",
    "absolute",
    "top-0",
    "right-0",
    "w-full",
    "lg:w-1/3",
    "xl:w-1/4",
    "text-lg",
    "lg:text-xl"
  );
  div.setAttribute("id", "notifications");
  body.appendChild(div);
}

function deleteNotification(id) {
  let notifications = document.getElementById("notifications");
  let notification = document.getElementById(id);

  if (notifications && notification) {
    notifications.removeChild(notification);
  }
}

function createNotification(message) {
  let notifications = document.getElementById("notifications");
  let id = Date.now().toString();

  let div1 = document.createElement("div");
  div1.classList.add("p-2");
  div1.setAttribute("id", id);

  let div2 = document.createElement("div");
  div2.classList.add(
    "w-full",
    "flex",
    "items-center",
    "justify-center",
    "bg-black",
    "p-4",
    "relative"
  );

  let p = document.createElement("p");
  p.appendChild(document.createTextNode(`${message}`));

  let icon = document.createElement("button");
  icon.classList.add("fa-solid", "fa-trash", "text-red-500", "text-lg", "p-3");
  icon.addEventListener("click", function () {
    deleteNotification(id);
  });

  div2.appendChild(p);
  div2.appendChild(icon);
  div1.appendChild(div2);
  notifications.appendChild(div1);

  let progressBar = document.createElement("div");
  progressBar.classList.add(
    "h-1",
    "bg-white",
    "bg-opacity-95",
    "absolute",
    "bottom-0",
    "left-0",
    "right-0"
  );
  div2.appendChild(progressBar);

  let duration = 10000;

  setTimeout(function () {
    deleteNotification(id);
  }, duration);

  let startTime = Date.now();
  let updateInterval = setInterval(function () {
    let elapsedTime = Date.now() - startTime;
    let progress = (elapsedTime / duration) * 100;
    progressBar.style.width = progress + "%";

    if (!document.getElementById(id)) {
      clearInterval(updateInterval);
    }
  }, 10);
}

function parameterNotifications() {
  let urlSearchParams = new URLSearchParams(location.search);
  let notifications = urlSearchParams.getAll("notification");
  notifications.forEach((notification) => {
    createNotification(notification);
  });
}

export { initializeNotifications, deleteNotification, createNotification, parameterNotifications };
