import { httpStatus } from "./httpStatus.js";

export async function customFetch(path, method, body) {
  let apiUrl = "https://localhost:5051";
  let requestBody = {
    method: `${method}`,
    headers: {
      Accept: "application/json",
      "Content-Type": "application/json",
      Authorization: `Bearer ${sessionStorage.getItem("Bearer")}`
    },
  };
  if (body) {
    requestBody.body = JSON.stringify(body);
  }

  
  let request = await fetch(`${apiUrl}/${path}`, requestBody);

  let response = {
    ok: request.ok,
    code: request.status,
    status: httpStatus[request.status],
  };

  if (request.ok) {
    try {
      response.data = await request.json();
    } catch (error) {
      response.data = error.message;
    }
  } else {
    try {
      response.message = (await request.json()).message;
    } catch (error) {
      response.message = error.message;
    }
  }

  return response;
}
