﻿using Onitama.Core.GameAggregate.Contracts;
using Onitama.Core.Util.Contracts;

namespace Onitama.Core.GameAggregate;

internal class GameService : IGameService
{
    private IGameRepository _gameRepository;
    public GameService(IGameRepository gameRepository)
    {
        _gameRepository = gameRepository;
    }

    public IGame GetGame(Guid gameId)
    {
        return _gameRepository.GetById(gameId);
    }

    public IReadOnlyList<IMove> GetPossibleMovesForPawn(Guid gameId, Guid playerId, Guid pawnId, string moveCardName)
    {
        IGame game = _gameRepository.GetById(gameId);
        return game.GetPossibleMovesForPawn(playerId, pawnId, moveCardName);
    }

    public void MovePawn(Guid gameId, Guid playerId, Guid pawnId, string moveCardName, ICoordinate to)
    {
        IGame game = _gameRepository.GetById(gameId);
        game.MovePawn(playerId, pawnId, moveCardName, to);
    }

    public void SkipMovementAndExchangeCard(Guid gameId, Guid playerId, string moveCardName)
    {
        IGame game = _gameRepository.GetById(gameId);
        game.SkipMovementAndExchangeCard(playerId, moveCardName);
    }
}