/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.ratelimits;

import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.util.HashMap;
import org.slf4j.Logger;

public class RateLimitManager {
    private static final Logger logger = LoggerUtil.getLogger(RateLimitManager.class);
    private final HashMap<RateLimitType, Long> rateLimits = new HashMap();
    private final HashMap<Server, HashMap<RateLimitType, Long>> serverRateLimits = new HashMap();
    private final HashMap<Channel, HashMap<RateLimitType, Long>> channelRateLimits = new HashMap();

    public void addRateLimit(RateLimitType type, long retryAfter) {
        this.addRateLimit(type, null, null, retryAfter);
    }

    public void addRateLimit(RateLimitType type, Server server, Channel channel, long retryAfter) {
        if (server == null && channel == null) {
            this.rateLimits.put(type, System.currentTimeMillis() + retryAfter);
        } else if (channel == null) {
            HashMap<RateLimitType, Long> rateLimits = this.serverRateLimits.get(server);
            if (rateLimits == null) {
                rateLimits = new HashMap();
                this.serverRateLimits.put(server, rateLimits);
            }
            rateLimits.put(type, System.currentTimeMillis() + retryAfter);
        } else {
            HashMap<RateLimitType, Long> rateLimits = this.channelRateLimits.get(channel);
            if (rateLimits == null) {
                rateLimits = new HashMap();
                this.channelRateLimits.put(channel, rateLimits);
            }
            rateLimits.put(type, System.currentTimeMillis() + retryAfter);
        }
    }

    public boolean isRateLimited(RateLimitType type) {
        return this.getRateLimit(type, null, null) > 0L;
    }

    public boolean isRateLimited(RateLimitType type, Server server) {
        return this.getRateLimit(type, server, null) > 0L;
    }

    public boolean isRateLimited(RateLimitType type, Channel channel) {
        return this.getRateLimit(type, null, channel) > 0L;
    }

    public boolean isRateLimited(RateLimitType type, Server server, Channel channel) {
        return this.getRateLimit(type, server, channel) > 0L;
    }

    public long getRateLimit(RateLimitType type) {
        return this.getRateLimit(type, null, null);
    }

    public long getRateLimit(RateLimitType type, Server server, Channel channel) {
        if (server == null && channel == null) {
            Long retryAt = this.rateLimits.get((Object)type);
            if (retryAt == null) {
                return -1L;
            }
            long retryAfter = retryAt - System.currentTimeMillis();
            return retryAfter <= 0L ? -1L : retryAfter;
        }
        if (channel == null) {
            HashMap<RateLimitType, Long> rateLimits = this.serverRateLimits.get(server);
            if (rateLimits == null) {
                return -1L;
            }
            Long retryAt = rateLimits.get((Object)type);
            if (retryAt == null) {
                return -1L;
            }
            long retryAfter = retryAt - System.currentTimeMillis();
            return retryAfter <= 0L ? -1L : retryAfter;
        }
        HashMap<RateLimitType, Long> rateLimits = this.channelRateLimits.get(channel);
        if (rateLimits == null) {
            return -1L;
        }
        Long retryAt = rateLimits.get((Object)type);
        if (retryAt == null) {
            return -1L;
        }
        long retryAfter = retryAt - System.currentTimeMillis();
        return retryAfter <= 0L ? -1L : retryAfter;
    }
}

