/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.voice;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.impl.ImplVoiceChannel;
import de.btobastian.javacord.listener.voice.UserJoinVoiceChannelListener;
import de.btobastian.javacord.listener.voice.UserLeaveVoiceChannelListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class VoiceStateUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(VoiceStateUpdateHandler.class);

    public VoiceStateUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "VOICE_STATE_UPDATE");
    }

    @Override
    public void handle(JSONObject packet) {
        ImplUser user = null;
        try {
            user = (ImplUser)this.api.getUserById(packet.getString("user_id")).get();
        }
        catch (InterruptedException | ExecutionException | JSONException e) {
            e.printStackTrace();
        }
        String channelId = null;
        try {
            channelId = packet.getString("channel_id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        final ImplUser userPassed = user;
        if (channelId != null) {
            ImplVoiceChannel channel;
            if (user.getVoiceChannel() != null) {
                if (channelId.equals(user.getVoiceChannel().getId())) {
                    return;
                }
                ((ImplVoiceChannel)user.getVoiceChannel()).removeConnectedUser(user);
            }
            if ((channel = (ImplVoiceChannel)this.api.getVoiceChannelById(channelId)) == null) {
                return;
            }
            channel.addConnectedUser(user);
            user.setVoiceChannel(channel);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<UserJoinVoiceChannelListener> listeners;
                    List<UserJoinVoiceChannelListener> list = listeners = VoiceStateUpdateHandler.this.api.getListeners(UserJoinVoiceChannelListener.class);
                    synchronized (list) {
                        for (UserJoinVoiceChannelListener listener : listeners) {
                            try {
                                listener.onUserJoinVoiceChannel(VoiceStateUpdateHandler.this.api, userPassed, channel);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in UserJoinVoiceChannelListener!", t);
                            }
                        }
                    }
                }
            });
        } else {
            if (user.getVoiceChannel() != null) {
                ((ImplVoiceChannel)user.getVoiceChannel()).removeConnectedUser(user);
            }
            user.setVoiceChannel(null);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<UserLeaveVoiceChannelListener> listeners;
                    List<UserLeaveVoiceChannelListener> list = listeners = VoiceStateUpdateHandler.this.api.getListeners(UserLeaveVoiceChannelListener.class);
                    synchronized (list) {
                        for (UserLeaveVoiceChannelListener listener : listeners) {
                            try {
                                listener.onUserLeaveVoiceChannel(VoiceStateUpdateHandler.this.api, userPassed);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in UserLeaveVoiceChannelListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

