/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.user;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.UserStatus;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.user.UserChangeGameListener;
import de.btobastian.javacord.listener.user.UserChangeNameListener;
import de.btobastian.javacord.listener.user.UserChangeStatusListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class PresenceUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(PresenceUpdateHandler.class);

    public PresenceUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "PRESENCE_UPDATE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(JSONObject packet) {
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (user == null) {
            return;
        }
        Server server = null;
        if (packet.has("guild_id")) {
            server = this.api.getServerById(packet.getString("guild_id"));
        }
        if (server != null) {
            ((ImplServer)server).addMember(user);
        }
        if (server != null && packet.has("roles")) {
            JSONArray roleIds = packet.getJSONArray("roles");
            for (int i = 0; i < roleIds.length(); ++i) {
                ((ImplRole)server.getRoleById(roleIds.getString(i))).addUserNoUpdate(user);
            }
        }
        if (packet.has("status")) {
            UserStatus status = UserStatus.fromString(packet.getString("status"));
            final UserStatus oldStatus = user.getStatus();
            ((ImplUser)user).setStatus(status);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<UserChangeStatusListener> listeners;
                    List<UserChangeStatusListener> list = listeners = PresenceUpdateHandler.this.api.getListeners(UserChangeStatusListener.class);
                    synchronized (list) {
                        for (UserChangeStatusListener listener : listeners) {
                            try {
                                listener.onUserChangeStatus(PresenceUpdateHandler.this.api, user, oldStatus);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in UserChangeStatusListener!", t);
                            }
                        }
                    }
                }
            });
        }
        if (packet.getJSONObject("user").has("username")) {
            String name = packet.getJSONObject("user").getString("username");
            if (!user.getName().equals(name)) {
                final String oldName = user.getName();
                ((ImplUser)user).setName(name);
                this.listenerExecutorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<UserChangeNameListener> listeners;
                        List<UserChangeNameListener> list = listeners = PresenceUpdateHandler.this.api.getListeners(UserChangeNameListener.class);
                        synchronized (list) {
                            for (UserChangeNameListener listener : listeners) {
                                try {
                                    listener.onUserChangeName(PresenceUpdateHandler.this.api, user, oldName);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in UserChangeNameListener!", t);
                                }
                            }
                        }
                    }
                });
            }
        }
        if (packet.has("game")) {
            String game = !packet.isNull("game") && packet.getJSONObject("game").has("name") && !packet.getJSONObject("game").isNull("name") ? packet.getJSONObject("game").get("name").toString() : null;
            String oldGame = user.getGame();
            if (game == null && oldGame != null || game != null && oldGame == null || game != null && !game.equals(oldGame)) {
                List<UserChangeGameListener> listeners;
                ((ImplUser)user).setGame(game);
                List<UserChangeGameListener> list = listeners = this.api.getListeners(UserChangeGameListener.class);
                synchronized (list) {
                    for (UserChangeGameListener listener : listeners) {
                        try {
                            listener.onUserChangeGame(this.api, user, oldGame);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in UserChangeGameListener!", t);
                        }
                    }
                }
            }
        }
    }
}

