/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server.role;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.role.RoleCreateListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildRoleCreateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildRoleCreateHandler.class);

    public GuildRoleCreateHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_ROLE_CREATE");
    }

    @Override
    public void handle(JSONObject packet) {
        String guildId = packet.getString("guild_id");
        JSONObject roleJson = packet.getJSONObject("role");
        Server server = this.api.getServerById(guildId);
        final ImplRole role = new ImplRole(roleJson, (ImplServer)server, this.api);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<RoleCreateListener> listeners;
                List<RoleCreateListener> list = listeners = GuildRoleCreateHandler.this.api.getListeners(RoleCreateListener.class);
                synchronized (list) {
                    for (RoleCreateListener listener : listeners) {
                        try {
                            listener.onRoleCreate(GuildRoleCreateHandler.this.api, role);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in RoleCreateListener!", t);
                        }
                    }
                }
            }
        });
    }
}

