/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Region;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.server.ServerChangeIconListener;
import de.btobastian.javacord.listener.server.ServerChangeNameListener;
import de.btobastian.javacord.listener.server.ServerChangeOwnerListener;
import de.btobastian.javacord.listener.server.ServerChangeRegionListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildUpdateHandler.class);

    public GuildUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_UPDATE");
    }

    @Override
    public void handle(JSONObject packet) {
        String icon;
        if (packet.has("unavailable") && packet.getBoolean("unavailable")) {
            return;
        }
        final ImplServer server = (ImplServer)this.api.getServerById(packet.getString("id"));
        String name = packet.getString("name");
        if (!server.getName().equals(name)) {
            final String oldName = server.getName();
            server.setName(name);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerChangeNameListener> listeners;
                    List<ServerChangeNameListener> list = listeners = GuildUpdateHandler.this.api.getListeners(ServerChangeNameListener.class);
                    synchronized (list) {
                        for (ServerChangeNameListener listener : listeners) {
                            try {
                                listener.onServerChangeName(GuildUpdateHandler.this.api, server, oldName);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerChangeNameListener!", t);
                            }
                        }
                    }
                }
            });
        }
        Region region = Region.getRegionByKey(packet.getString("region"));
        if (server.getRegion() != region) {
            final Region oldRegion = server.getRegion();
            server.setRegion(region);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerChangeRegionListener> listeners;
                    List<ServerChangeRegionListener> list = listeners = GuildUpdateHandler.this.api.getListeners(ServerChangeRegionListener.class);
                    synchronized (list) {
                        for (ServerChangeRegionListener listener : listeners) {
                            try {
                                listener.onServerChangeRegion(GuildUpdateHandler.this.api, server, oldRegion);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerChangeRegionListener!", t);
                            }
                        }
                    }
                }
            });
        }
        String ownerId = packet.getString("owner_id");
        if (!server.getOwnerId().equals(ownerId)) {
            final String oldOwnerId = server.getOwnerId();
            server.setOwnerId(ownerId);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerChangeOwnerListener> listeners;
                    List<ServerChangeOwnerListener> list = listeners = GuildUpdateHandler.this.api.getListeners(ServerChangeOwnerListener.class);
                    synchronized (list) {
                        for (ServerChangeOwnerListener listener : listeners) {
                            try {
                                listener.onServerChangeOwner(GuildUpdateHandler.this.api, server, oldOwnerId);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerChangeOwnerListener!", t);
                            }
                        }
                    }
                }
            });
        }
        String string = icon = packet.isNull("icon") ? null : packet.getString("icon");
        if (server.getIconHash() != null && !server.getIconHash().equals(icon)) {
            final String oldIcon = server.getIconHash();
            server.setIconHash(icon);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerChangeIconListener> listeners;
                    List<ServerChangeIconListener> list = listeners = GuildUpdateHandler.this.api.getListeners(ServerChangeIconListener.class);
                    synchronized (list) {
                        for (ServerChangeIconListener listener : listeners) {
                            try {
                                listener.onServerChangeIcon(GuildUpdateHandler.this.api, server, oldIcon);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerChangeIconListener!", t);
                            }
                        }
                    }
                }
            });
        } else if (server.getIconHash() == null && server.getIconHash() != icon) {
            final String oldIcon = server.getIconHash();
            server.setIconHash(icon);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerChangeIconListener> listeners;
                    List<ServerChangeIconListener> list = listeners = GuildUpdateHandler.this.api.getListeners(ServerChangeIconListener.class);
                    synchronized (list) {
                        for (ServerChangeIconListener listener : listeners) {
                            try {
                                listener.onServerChangeIcon(GuildUpdateHandler.this.api, server, oldIcon);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerChangeIconListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

