/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.user.UserChangeNicknameListener;
import de.btobastian.javacord.listener.user.UserRoleAddListener;
import de.btobastian.javacord.listener.user.UserRoleRemoveListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildMemberUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildMemberUpdateHandler.class);

    public GuildMemberUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_MEMBER_UPDATE");
    }

    @Override
    public void handle(JSONObject packet) {
        final ImplServer server = (ImplServer)this.api.getServerById(packet.getString("guild_id"));
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (server != null) {
            if (packet.has("nick")) {
                String newNick = packet.isNull("nick") ? null : packet.getString("nick");
                final String oldNick = server.getNickname(user);
                if (newNick != null && !newNick.equals(oldNick) || oldNick != null && !oldNick.equals(newNick)) {
                    server.setNickname(user, newNick);
                    this.listenerExecutorService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserChangeNicknameListener> listeners;
                            List<UserChangeNicknameListener> list = listeners = GuildMemberUpdateHandler.this.api.getListeners(UserChangeNicknameListener.class);
                            synchronized (list) {
                                for (UserChangeNicknameListener listener : listeners) {
                                    try {
                                        listener.onUserChangeNickname(GuildMemberUpdateHandler.this.api, server, user, oldNick);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in UserChangeNicknameListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            JSONArray jsonRoles = packet.getJSONArray("roles");
            Role[] roles = new Role[jsonRoles.length()];
            for (int i = 0; i < jsonRoles.length(); ++i) {
                roles[i] = server.getRoleById(jsonRoles.getString(i));
            }
            for (final Role role : user.getRoles(server)) {
                boolean contains = false;
                for (Role r : roles) {
                    if (role != r) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                ((ImplRole)role).removeUserNoUpdate(user);
                this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<UserRoleRemoveListener> listeners;
                        List<UserRoleRemoveListener> list = listeners = GuildMemberUpdateHandler.this.api.getListeners(UserRoleRemoveListener.class);
                        synchronized (list) {
                            for (UserRoleRemoveListener listener : listeners) {
                                try {
                                    listener.onUserRoleRemove(GuildMemberUpdateHandler.this.api, user, role);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in UserRoleRemoveListenerListener!", t);
                                }
                            }
                        }
                    }
                });
            }
            for (final Role role : roles) {
                if (user.getRoles(server).contains(role)) continue;
                ((ImplRole)role).addUserNoUpdate(user);
                this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<UserRoleAddListener> listeners;
                        List<UserRoleAddListener> list = listeners = GuildMemberUpdateHandler.this.api.getListeners(UserRoleAddListener.class);
                        synchronized (list) {
                            for (UserRoleAddListener listener : listeners) {
                                try {
                                    listener.onUserRoleAdd(GuildMemberUpdateHandler.this.api, user, role);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in UserRoleAddListener!", t);
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

