/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.server.ServerMemberRemoveListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildMemberRemoveHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildMemberRemoveHandler.class);

    public GuildMemberRemoveHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_MEMBER_REMOVE");
    }

    @Override
    public void handle(JSONObject packet) {
        final Server server = this.api.getServerById(packet.getString("guild_id"));
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (server != null) {
            ((ImplServer)server).removeMember(user);
            ((ImplServer)server).decrementMemberCount();
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerMemberRemoveListener> listeners;
                    List<ServerMemberRemoveListener> list = listeners = GuildMemberRemoveHandler.this.api.getListeners(ServerMemberRemoveListener.class);
                    synchronized (list) {
                        for (ServerMemberRemoveListener listener : listeners) {
                            try {
                                listener.onServerMemberRemove(GuildMemberRemoveHandler.this.api, user, server);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerMemberRemoveListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

