/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.listener.server.ServerMemberBanListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildBanAddHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildBanAddHandler.class);

    public GuildBanAddHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_BAN_ADD");
    }

    @Override
    public void handle(JSONObject packet) {
        final Server server = this.api.getServerById(packet.getString("guild_id"));
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (server != null) {
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerMemberBanListener> listeners;
                    List<ServerMemberBanListener> list = listeners = GuildBanAddHandler.this.api.getListeners(ServerMemberBanListener.class);
                    synchronized (list) {
                        for (ServerMemberBanListener listener : listeners) {
                            try {
                                listener.onServerMemberBan(GuildBanAddHandler.this.api, user, server);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerMemberBanListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

