/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.message;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.listener.message.TypingStartListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class TypingStartHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(TypingStartHandler.class);

    public TypingStartHandler(ImplDiscordAPI api) {
        super(api, true, "TYPING_START");
    }

    @Override
    public void handle(JSONObject packet) {
        User user;
        Channel channelTemp = null;
        String channelId = packet.getString("channel_id");
        Iterator<Server> serverIterator = this.api.getServers().iterator();
        while (serverIterator.hasNext() && (channelTemp = serverIterator.next().getChannelById(channelId)) == null) {
        }
        final Channel channel = channelTemp;
        String userId = packet.getString("user_id");
        try {
            user = this.api.getUserById(userId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return;
        }
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<TypingStartListener> listeners;
                List<TypingStartListener> list = listeners = TypingStartHandler.this.api.getListeners(TypingStartListener.class);
                synchronized (list) {
                    for (TypingStartListener listener : listeners) {
                        try {
                            listener.onTypingStart(TypingStartHandler.this.api, user, channel);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in TypingStartListener!", t);
                        }
                    }
                }
            }
        });
    }
}

