/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.message;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.listener.message.MessageEditListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class MessageUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(MessageUpdateHandler.class);

    public MessageUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "MESSAGE_UPDATE");
    }

    @Override
    public void handle(JSONObject packet) {
        String messageId = packet.getString("id");
        final Message message = this.api.getMessageById(messageId);
        if (message == null) {
            return;
        }
        final String oldContent = message.getContent();
        if (!packet.has("content")) {
            return;
        }
        ((ImplMessage)message).setContent(packet.getString("content"));
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<MessageEditListener> listeners;
                List<MessageEditListener> list = listeners = MessageUpdateHandler.this.api.getListeners(MessageEditListener.class);
                synchronized (list) {
                    for (MessageEditListener listener : listeners) {
                        try {
                            listener.onMessageEdit(MessageUpdateHandler.this.api, message, oldContent);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in MessageEditListener!", t);
                        }
                    }
                }
            }
        });
    }
}

