/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.message;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.Reaction;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.listener.message.ReactionAddListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class MessageReactionAddHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(MessageReactionAddHandler.class);

    public MessageReactionAddHandler(ImplDiscordAPI api) {
        super(api, true, "MESSAGE_REACTION_ADD");
    }

    @Override
    public void handle(JSONObject packet) {
        User user;
        String userId = packet.getString("user_id");
        String messageId = packet.getString("message_id");
        JSONObject emoji = packet.getJSONObject("emoji");
        boolean isCustomEmoji = !emoji.isNull("id");
        Message message = this.api.getMessageById(messageId);
        if (message == null) {
            return;
        }
        Reaction reaction = null;
        if (isCustomEmoji) {
            String emojiId = emoji.getString("id");
            if (message.isPrivateMessage()) {
                return;
            }
            CustomEmoji customEmoji = message.getChannelReceiver().getServer().getCustomEmojiById(emojiId);
            if (customEmoji == null) {
                return;
            }
            reaction = ((ImplMessage)message).addCustomEmojiReactionToCache(customEmoji, this.api.getYourself().getId().equals(userId));
        } else {
            reaction = ((ImplMessage)message).addUnicodeReactionToCache(emoji.getString("name"), this.api.getYourself().getId().equals(userId));
        }
        if (reaction != null && (user = this.api.getCachedUserById(userId)) != null) {
            final Reaction reactionFinal = reaction;
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ReactionAddListener> listeners;
                    List<ReactionAddListener> list = listeners = MessageReactionAddHandler.this.api.getListeners(ReactionAddListener.class);
                    synchronized (list) {
                        for (ReactionAddListener listener : listeners) {
                            try {
                                listener.onReactionAdd(MessageReactionAddHandler.this.api, reactionFinal, user);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ReactionAddListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

