/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.message;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.listener.message.MessageDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class MessageBulkDeleteHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(MessageBulkDeleteHandler.class);

    public MessageBulkDeleteHandler(ImplDiscordAPI api) {
        super(api, true, "MESSAGE_DELETE_BULK");
    }

    @Override
    public void handle(JSONObject packet) {
        JSONArray messageIds = packet.getJSONArray("ids");
        for (int i = 0; i < messageIds.length(); ++i) {
            String messageId = messageIds.getString(i);
            final Message message = this.api.getMessageById(messageId);
            if (message == null) {
                return;
            }
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<MessageDeleteListener> listeners;
                    List<MessageDeleteListener> list = listeners = MessageBulkDeleteHandler.this.api.getListeners(MessageDeleteListener.class);
                    synchronized (list) {
                        for (MessageDeleteListener listener : listeners) {
                            try {
                                listener.onMessageDelete(MessageBulkDeleteHandler.this.api, message);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in MessageDeleteListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

