/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.channel;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.channel.ChannelDeleteListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ChannelDeleteHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelDeleteHandler.class);

    public ChannelDeleteHandler(ImplDiscordAPI api) {
        super(api, true, "CHANNEL_DELETE");
    }

    @Override
    public void handle(JSONObject packet) {
        int type = packet.getInt("type");
        if (type == 0) {
            this.handleServerTextChannel(packet, this.api.getServerById(packet.getString("guild_id")));
        } else if (type == 2) {
            this.handleServerVoiceChannel(packet, this.api.getServerById(packet.getString("guild_id")));
        }
    }

    private void handleServerTextChannel(JSONObject packet, Server server) {
        final Channel channel = server.getChannelById(packet.getString("id"));
        if (channel == null) {
            return;
        }
        ((ImplServer)server).removeChannel(channel);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ChannelDeleteListener> listeners;
                List<ChannelDeleteListener> list = listeners = ChannelDeleteHandler.this.api.getListeners(ChannelDeleteListener.class);
                synchronized (list) {
                    for (ChannelDeleteListener listener : listeners) {
                        try {
                            listener.onChannelDelete(ChannelDeleteHandler.this.api, channel);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in ChannelDeleteListener!", t);
                        }
                    }
                }
            }
        });
    }

    private void handleServerVoiceChannel(JSONObject packet, Server server) {
        final VoiceChannel channel = server.getVoiceChannelById(packet.getString("id"));
        if (channel == null) {
            return;
        }
        ((ImplServer)server).removeVoiceChannel(channel);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<VoiceChannelDeleteListener> listeners;
                List<VoiceChannelDeleteListener> list = listeners = ChannelDeleteHandler.this.api.getListeners(VoiceChannelDeleteListener.class);
                synchronized (list) {
                    for (VoiceChannelDeleteListener listener : listeners) {
                        try {
                            listener.onVoiceChannelDelete(ChannelDeleteHandler.this.api, channel);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in VoiceChannelDeleteListener!", t);
                        }
                    }
                }
            }
        });
    }
}

